/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.kv.CoreRangeScan;
import com.couchbase.client.core.kv.CoreScanTerm;
import com.couchbase.client.java.kv.ScanTerm;
import com.couchbase.client.java.kv.ScanType;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class RangeScan
extends ScanType {
    @Nullable
    private final ScanTerm from;
    @Nullable
    private final ScanTerm to;

    RangeScan(@Nullable ScanTerm from, @Nullable ScanTerm to) {
        this.from = from;
        this.to = to;
    }

    public Optional<ScanTerm> from() {
        return Optional.ofNullable(this.from);
    }

    public Optional<ScanTerm> to() {
        return Optional.ofNullable(this.to);
    }

    @Override
    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    implements CoreRangeScan {
        @Override
        public CoreScanTerm from() {
            return RangeScan.this.from == null ? CoreScanTerm.MIN : RangeScan.this.from.toCore();
        }

        @Override
        public CoreScanTerm to() {
            return RangeScan.this.to == null ? CoreScanTerm.MAX : RangeScan.this.to.toCore();
        }
    }
}

