/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.MutationState;
import java.util.Optional;

@Stability.Volatile
public class ScanOptions
extends CommonOptions<ScanOptions> {
    private boolean idsOnly = false;
    private int batchItemLimit = 50;
    private int batchByteLimit = 15000;
    private Optional<MutationState> consistentWith = Optional.empty();
    private Transcoder transcoder;

    public static ScanOptions scanOptions() {
        return new ScanOptions();
    }

    private ScanOptions() {
    }

    public ScanOptions idsOnly(boolean idsOnly) {
        this.idsOnly = idsOnly;
        return this;
    }

    public ScanOptions transcoder(Transcoder transcoder) {
        this.transcoder = Validators.notNull(transcoder, "Transcoder");
        return this;
    }

    public ScanOptions consistentWith(MutationState mutationState) {
        this.consistentWith = Optional.ofNullable(mutationState);
        return this;
    }

    public ScanOptions batchByteLimit(int batchByteLimit) {
        if (batchByteLimit < 0) {
            throw InvalidArgumentException.fromMessage("The batchByteLimit must not be smaller than 0");
        }
        this.batchByteLimit = batchByteLimit;
        return this;
    }

    public ScanOptions batchItemLimit(int batchItemLimit) {
        if (batchItemLimit < 0) {
            throw InvalidArgumentException.fromMessage("The batchItemLimit must not be smaller than 0");
        }
        this.batchItemLimit = batchItemLimit;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreScanOptions {
        public Built() {
            super(ScanOptions.this);
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }

        @Override
        public boolean idsOnly() {
            return ScanOptions.this.idsOnly;
        }

        public Transcoder transcoder() {
            return ScanOptions.this.transcoder;
        }

        @Override
        public CoreMutationState consistentWith() {
            return ScanOptions.this.consistentWith.map(CoreMutationState::new).orElse(null);
        }

        @Override
        public int batchItemLimit() {
            return ScanOptions.this.batchItemLimit;
        }

        @Override
        public int batchByteLimit() {
            return ScanOptions.this.batchByteLimit;
        }
    }
}

