/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.kv.CoreScanTerm;
import com.couchbase.client.core.util.Validators;

@Stability.Volatile
public class ScanTerm {
    private final String id;
    private final boolean exclusive;

    private ScanTerm(String id, boolean exclusive) {
        this.id = Validators.notNullOrEmpty(id, "ScanTerm ID");
        this.exclusive = exclusive;
    }

    public String id() {
        return this.id;
    }

    public boolean exclusive() {
        return this.exclusive;
    }

    public static ScanTerm inclusive(String id) {
        return new ScanTerm(id, false);
    }

    public static ScanTerm exclusive(String id) {
        return new ScanTerm(id, true);
    }

    @Stability.Internal
    public CoreScanTerm toCore() {
        return new CoreScanTerm(this.id, this.exclusive);
    }

    public String toString() {
        return "ScanTerm{id='" + this.id + '\'' + ", exclusive=" + this.exclusive + '}';
    }
}

