/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.manager.CoreCollectionManager;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateCollectionSettings;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.couchbase.client.java.manager.collection.UpdateCollectionOptions;
import com.couchbase.client.java.manager.collection.UpdateCollectionSettings;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Stability.Volatile
public class AsyncCollectionManager {
    private final CoreCollectionManager coreCollectionManager;
    private final AsyncCluster cluster;

    @Stability.Internal
    public AsyncCollectionManager(CoreCollectionManager coreCollectionManager, AsyncCluster cluster) {
        this.coreCollectionManager = Objects.requireNonNull(coreCollectionManager);
        this.cluster = Objects.requireNonNull(cluster);
    }

    @Deprecated
    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec) {
        return this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    @Deprecated
    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        return this.createCollection(collectionSpec.scopeName(), collectionSpec.name(), CreateCollectionSettings.createCollectionSettings().maxExpiry(collectionSpec.maxExpiry()), options);
    }

    @Stability.Volatile
    public CompletableFuture<Void> createCollection(String scopeName, String collectionName, CreateCollectionSettings settings) {
        return this.coreCollectionManager.createCollection(scopeName, collectionName, settings.build(), CreateCollectionOptions.createCollectionOptions().build());
    }

    @Stability.Volatile
    public CompletableFuture<Void> createCollection(String scopeName, String collectionName, CreateCollectionSettings settings, CreateCollectionOptions options) {
        return this.coreCollectionManager.createCollection(scopeName, collectionName, settings.build(), options.build());
    }

    public CompletableFuture<Void> createScope(String scopeName) {
        return this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public CompletableFuture<Void> createScope(String scopeName, CreateScopeOptions options) {
        return this.coreCollectionManager.createScope(scopeName, options.build());
    }

    @Stability.Volatile
    public CompletableFuture<Void> updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings) {
        return this.updateCollection(scopeName, collectionName, settings, UpdateCollectionOptions.updateCollectionOptions());
    }

    @Stability.Volatile
    public CompletableFuture<Void> updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings, UpdateCollectionOptions options) {
        return this.coreCollectionManager.updateCollection(scopeName, collectionName, settings.build(), options.build());
    }

    @Deprecated
    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec) {
        return this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    @Deprecated
    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        return this.coreCollectionManager.dropCollection(collectionSpec.scopeName(), collectionSpec.name(), options.build());
    }

    @Stability.Volatile
    public CompletableFuture<Void> dropCollection(String scopeName, String collectionName) {
        return this.dropCollection(scopeName, collectionName, DropCollectionOptions.dropCollectionOptions());
    }

    @Stability.Volatile
    public CompletableFuture<Void> dropCollection(String scopeName, String collectionName, DropCollectionOptions options) {
        return this.coreCollectionManager.dropCollection(scopeName, collectionName, options.build());
    }

    public CompletableFuture<Void> dropScope(String scopeName) {
        return this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public CompletableFuture<Void> dropScope(String scopeName, DropScopeOptions options) {
        return this.coreCollectionManager.dropScope(scopeName, options.build());
    }

    @Deprecated
    public CompletableFuture<ScopeSpec> getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    @Deprecated
    public CompletableFuture<ScopeSpec> getScope(String scopeName, GetScopeOptions options) {
        Validators.notNullOrEmpty(scopeName, "ScopeName");
        Validators.notNull(options, "Options");
        GetScopeOptions.Built opts = options.build();
        GetAllScopesOptions toPassOptions = GetAllScopesOptions.getAllScopesOptions();
        opts.timeout().ifPresent(toPassOptions::timeout);
        opts.retryStrategy().ifPresent(toPassOptions::retryStrategy);
        return this.getAllScopes(toPassOptions).thenApply(scopes -> {
            Optional<ScopeSpec> scope = scopes.stream().filter(s -> s.name().equals(scopeName)).findFirst();
            if (scope.isPresent()) {
                return scope.get();
            }
            throw ScopeNotFoundException.forScope(scopeName);
        });
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes(GetAllScopesOptions options) {
        return this.coreCollectionManager.getAllScopes(options.build()).thenApply(manifest -> manifest.scopes().stream().map(s -> ScopeSpec.create(s.name(), s.collections().stream().map(c -> CollectionSpec.internalCreate(c.name(), s.name(), c.maxExpiry() == null ? Duration.ZERO : Duration.ofSeconds(c.maxExpiry().intValue()), c.history())).collect(Collectors.toSet()))).collect(Collectors.toList()));
    }
}

