/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.manager.CoreCollectionQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Stability.Volatile
public class AsyncCollectionQueryIndexManager {
    private final CoreCollectionQueryIndexManager internal;

    @Stability.Internal
    public AsyncCollectionQueryIndexManager(CoreQueryOps queryOps, RequestTracer requestTracer, CoreKeyspace collection) {
        this.internal = new CoreCollectionQueryIndexManager(queryOps, requestTracer, collection);
    }

    public CompletableFuture<Void> createIndex(String indexName, Collection<String> fields) {
        return this.createIndex(indexName, fields, CreateQueryIndexOptions.createQueryIndexOptions());
    }

    public CompletableFuture<Void> createIndex(String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return this.internal.createIndex(indexName, fields, options.build());
    }

    public CompletableFuture<Void> createPrimaryIndex() {
        return this.createPrimaryIndex(CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> createPrimaryIndex(CreatePrimaryQueryIndexOptions options) {
        return this.internal.createPrimaryIndex(options.build());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllQueryIndexesOptions.getAllQueryIndexesOptions());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(GetAllQueryIndexesOptions options) {
        return this.internal.getAllIndexes(options.build()).thenApply(rows -> rows.stream().map(row -> new QueryIndex((CoreQueryIndex)row)).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex() {
        return this.dropPrimaryIndex(DropPrimaryQueryIndexOptions.dropPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> dropPrimaryIndex(DropPrimaryQueryIndexOptions options) {
        return this.internal.dropPrimaryIndex(options.build());
    }

    public CompletableFuture<Void> dropIndex(String indexName) {
        return this.dropIndex(indexName, DropQueryIndexOptions.dropQueryIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String indexName, DropQueryIndexOptions options) {
        return this.internal.dropIndex(indexName, options.build());
    }

    public CompletableFuture<Void> buildDeferredIndexes() {
        return this.buildDeferredIndexes(BuildQueryIndexOptions.buildDeferredQueryIndexesOptions());
    }

    public CompletableFuture<Void> buildDeferredIndexes(BuildQueryIndexOptions options) {
        return this.internal.buildDeferredIndexes(options.build());
    }

    public CompletableFuture<Void> watchIndexes(Collection<String> indexNames, Duration timeout) {
        return this.watchIndexes(indexNames, timeout, WatchQueryIndexesOptions.watchQueryIndexesOptions());
    }

    public CompletableFuture<Void> watchIndexes(Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return this.internal.watchIndexes(indexNames, timeout, options.build());
    }
}

