/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreDropPrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;

public class DropPrimaryQueryIndexOptions
extends CommonOptions<DropPrimaryQueryIndexOptions> {
    private boolean ignoreIfNotExists;
    private String scopeName;
    private String collectionName;

    private DropPrimaryQueryIndexOptions() {
    }

    public static DropPrimaryQueryIndexOptions dropPrimaryQueryIndexOptions() {
        return new DropPrimaryQueryIndexOptions();
    }

    public DropPrimaryQueryIndexOptions ignoreIfNotExists(boolean ignore) {
        this.ignoreIfNotExists = ignore;
        return this;
    }

    @Deprecated
    public DropPrimaryQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    @Deprecated
    public DropPrimaryQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreDropPrimaryQueryIndexOptions {
        Built() {
        }

        @Override
        public boolean ignoreIfNotExists() {
            return DropPrimaryQueryIndexOptions.this.ignoreIfNotExists;
        }

        @Override
        public CoreScopeAndCollection scopeAndCollection() {
            if (DropPrimaryQueryIndexOptions.this.scopeName != null && DropPrimaryQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(DropPrimaryQueryIndexOptions.this.scopeName, DropPrimaryQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

