/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.api.manager.CoreWatchQueryIndexesOptions;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;

public class WatchQueryIndexesOptions
extends CommonOptions<WatchQueryIndexesOptions> {
    private boolean watchPrimary;
    private String scopeName;
    private String collectionName;

    private WatchQueryIndexesOptions() {
    }

    public static WatchQueryIndexesOptions watchQueryIndexesOptions() {
        return new WatchQueryIndexesOptions();
    }

    public WatchQueryIndexesOptions watchPrimary(boolean watchPrimary) {
        this.watchPrimary = watchPrimary;
        return this;
    }

    @Deprecated
    public WatchQueryIndexesOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    @Deprecated
    public WatchQueryIndexesOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreWatchQueryIndexesOptions {
        Built() {
        }

        @Override
        public boolean watchPrimary() {
            return WatchQueryIndexesOptions.this.watchPrimary;
        }

        @Override
        public CoreScopeAndCollection scopeAndCollection() {
            if (WatchQueryIndexesOptions.this.scopeName != null && WatchQueryIndexesOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(WatchQueryIndexesOptions.this.scopeName, WatchQueryIndexesOptions.this.collectionName);
            }
            return null;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

