/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.manager.search.CoreSearchIndexManager;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.SearchIndexManagerUtil;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncScopeSearchIndexManager {
    private final CoreSearchIndexManager internal;
    private final AsyncCluster cluster;

    public AsyncScopeSearchIndexManager(CoreCouchbaseOps couchbaseOps, AsyncScope scope, AsyncCluster cluster) {
        this.internal = couchbaseOps.scopeSearchIndexManager(new CoreBucketAndScope(scope.bucketName(), scope.name()));
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<SearchIndex> getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public CompletableFuture<SearchIndex> getIndex(String name, GetSearchIndexOptions options) {
        return this.internal.getIndex(name, options.build()).thenApply(SearchIndexManagerUtil::convert);
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes(GetAllSearchIndexesOptions options) {
        return this.internal.getAllIndexes(options.build()).thenApply(indexes -> indexes.stream().map(SearchIndexManagerUtil::convert).collect(Collectors.toList()));
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        return this.internal.getIndexedDocumentsCount(name, options.build());
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index) {
        return this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        return this.internal.upsertIndex(SearchIndexManagerUtil.convert(index), options.build());
    }

    public CompletableFuture<Void> dropIndex(String name) {
        return this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String name, DropSearchIndexOptions options) {
        return this.internal.dropIndex(name, options.build());
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        try {
            ObjectNode json = (ObjectNode)Mapper.reader().readTree(document.toBytes());
            return this.internal.analyzeDocument(name, json, options.build()).thenApply(list -> list.stream().map(o -> JsonObject.fromJson(o.toString())).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new DecodingFailureException("Failed to decode document", e);
        }
    }

    public CompletableFuture<Void> pauseIngest(String name) {
        return this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        return this.internal.pauseIngest(name, options.build());
    }

    public CompletableFuture<Void> resumeIngest(String name) {
        return this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        return this.internal.resumeIngest(name, options.build());
    }

    public CompletableFuture<Void> allowQuerying(String name) {
        return this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        return this.internal.allowQuerying(name, options.build());
    }

    public CompletableFuture<Void> disallowQuerying(String name) {
        return this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        return this.internal.disallowQuerying(name, options.build());
    }

    public CompletableFuture<Void> freezePlan(String name) {
        return this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> freezePlan(String name, FreezePlanSearchIndexOptions options) {
        return this.internal.freezePlan(name, options.build());
    }

    public CompletableFuture<Void> unfreezePlan(String name) {
        return this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        return this.internal.unfreezePlan(name, options.build());
    }
}

