/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.vector.CoreVector;
import com.couchbase.client.core.api.search.vector.CoreVectorQuery;
import com.couchbase.client.core.util.Validators;
import reactor.util.annotation.Nullable;

public class VectorQuery {
    private final CoreVector vector;
    private final String vectorField;
    @Nullable
    private Integer numCandidates;
    @Nullable
    private Double boost;

    private VectorQuery(String vectorField, float[] vector) {
        this.vectorField = Validators.notNull(vectorField, "vectorField");
        this.vector = CoreVector.of(vector);
    }

    private VectorQuery(String vectorField, String base64EncodedVector) {
        this.vectorField = Validators.notNull(vectorField, "vectorField");
        this.vector = CoreVector.of(base64EncodedVector);
    }

    public static VectorQuery create(String vectorField, float[] vector) {
        return new VectorQuery(vectorField, vector);
    }

    public static VectorQuery create(String vectorField, String base64EncodedVector) {
        return new VectorQuery(vectorField, base64EncodedVector);
    }

    public VectorQuery numCandidates(int numCandidates) {
        this.numCandidates = numCandidates;
        return this;
    }

    public VectorQuery boost(double boost) {
        this.boost = boost;
        return this;
    }

    @Stability.Internal
    public CoreVectorQuery toCore() {
        return new CoreVectorQuery(this.vector, this.vectorField, this.numCandidates, this.boost);
    }
}

