/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionContext;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.config.CoreTransactionOptions;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarker;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarkerOwner;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.transactions.ReactiveTransactionAttemptContext;
import com.couchbase.client.java.transactions.TransactionAttemptContext;
import com.couchbase.client.java.transactions.TransactionResult;
import com.couchbase.client.java.transactions.config.TransactionOptions;
import com.couchbase.client.java.transactions.internal.ErrorUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ReactiveTransactions {
    private final CoreTransactionsReactive internal;
    private final JsonSerializer serializer;

    @Stability.Internal
    public ReactiveTransactions(Core core, JsonSerializer serializer) {
        Objects.requireNonNull(core);
        this.internal = new CoreTransactionsReactive(core, core.context().environment().transactionsConfig());
        this.serializer = Objects.requireNonNull(serializer);
    }

    public Mono<TransactionResult> run(Function<ReactiveTransactionAttemptContext, Mono<?>> transactionLogic, @Nullable TransactionOptions options) {
        return this.internal.run((CoreTransactionAttemptContext ctx) -> (Mono)transactionLogic.apply(new ReactiveTransactionAttemptContext((CoreTransactionAttemptContext)ctx, this.serializer)), options == null ? null : options.build()).onErrorResume(ErrorUtil::convertTransactionFailedInternal).map(TransactionResult::new);
    }

    public Mono<TransactionResult> run(Function<ReactiveTransactionAttemptContext, Mono<?>> transactionLogic) {
        return this.run(transactionLogic, null);
    }

    TransactionResult runBlocking(Consumer<TransactionAttemptContext> transactionLogic, @Nullable CoreTransactionOptions perConfig) {
        return Mono.defer(() -> {
            CoreMergedTransactionConfig merged = new CoreMergedTransactionConfig(this.internal.config(), Optional.ofNullable(perConfig));
            CoreTransactionContext overall = new CoreTransactionContext(this.internal.core().context(), UUID.randomUUID().toString(), merged, this.internal.core().transactionsCleanup());
            Mono<CoreTransactionAttemptContext> createAttempt = Mono.defer(() -> {
                String attemptId = UUID.randomUUID().toString();
                return Mono.just(this.internal.createAttemptContext(overall, merged, attemptId));
            });
            Function<CoreTransactionAttemptContext, Mono<Void>> newTransactionLogic = ctx -> Mono.defer(() -> {
                TransactionAttemptContext ctxBlocking = new TransactionAttemptContext((CoreTransactionAttemptContext)ctx, this.serializer);
                return Mono.fromRunnable(() -> {
                    TransactionMarkerOwner.set(new TransactionMarker((CoreTransactionAttemptContext)ctx));
                    try {
                        transactionLogic.accept(ctxBlocking);
                    }
                    finally {
                        TransactionMarkerOwner.clear();
                    }
                }).subscribeOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).then();
            });
            return this.internal.executeTransaction(createAttempt, merged, overall, newTransactionLogic, false).onErrorResume(ErrorUtil::convertTransactionFailedInternal);
        }).map(TransactionResult::new).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).block();
    }
}

