/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.internal;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class EncodingUtil {
    private EncodingUtil() {
    }

    public static Transcoder.EncodedValue encode(Object content, RequestSpan span, JsonSerializer serializer, @Nullable Transcoder transcoder, CoreContext coreContext) {
        Transcoder.EncodedValue encoded;
        RequestSpan encoding = CbTracing.newSpan(coreContext, "request_encoding", span);
        try {
            if (transcoder != null) {
                encoded = transcoder.encode(content);
            } else {
                byte[] bytes = serializer.serialize(content);
                encoded = new Transcoder.EncodedValue(bytes, CodecFlags.JSON_COMPAT_FLAGS);
            }
            encoding.end();
        }
        catch (Throwable err) {
            encoding.recordException(err);
            encoding.status(RequestSpan.StatusCode.ERROR);
            throw err;
        }
        return encoded;
    }
}

