/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.msg.view.ViewResponse;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.view.ViewMetaData;
import com.couchbase.client.java.view.ViewRow;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveViewResult {
    private final ViewResponse response;
    private final JsonSerializer serializer;

    ReactiveViewResult(ViewResponse response, JsonSerializer serializer) {
        this.response = response;
        this.serializer = serializer;
    }

    public Flux<ViewRow> rows() {
        return this.response.rows().map(r -> new ViewRow(r.data(), this.serializer));
    }

    public Mono<ViewMetaData> metaData() {
        return Mono.just(ViewMetaData.from(this.response.header()));
    }
}

