/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.TokenServerResponse;
import com.ibm.cloud.sdk.core.security.VpcTokenResponse;
import com.ibm.cloud.sdk.core.service.model.ObjectModel;
import com.ibm.cloud.sdk.core.util.Clock;

public class IamToken
extends AbstractToken
implements ObjectModel,
TokenServerResponse {
    public static final long IamExpirationWindow = 10L;
    @SerializedName(value="access_token")
    private String accessToken;
    @SerializedName(value="refresh_token")
    private String refreshToken;
    @SerializedName(value="token_type")
    private String tokenType;
    @SerializedName(value="expires_in")
    private Long expiresIn;
    private Long expiration;
    private Long refreshTime;

    public IamToken() {
    }

    public IamToken(Throwable t) {
        super(t);
    }

    public IamToken(VpcTokenResponse vpcResponse) {
        this.accessToken = vpcResponse.getAccessToken();
        this.expiresIn = vpcResponse.getExpiresIn();
        this.expiration = vpcResponse.getExpiresAt().getTime() / 1000L;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public Long getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public synchronized boolean needsRefresh() {
        if (this.getException() != null) {
            return true;
        }
        if (this.refreshTime == null && this.getExpiresIn() != null && this.expiration != null) {
            Double fractionOfTimeToLive = 0.8;
            Long timeToLive = this.getExpiresIn();
            this.refreshTime = this.expiration - (long)((double)timeToLive.longValue() * (1.0 - fractionOfTimeToLive));
        }
        if (this.refreshTime != null && Clock.getCurrentTimeInSeconds() > this.refreshTime) {
            this.refreshTime = Clock.getCurrentTimeInSeconds() + 60L;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTokenValid() {
        return this.getException() == null && (this.expiration == null || Clock.getCurrentTimeInSeconds() < this.expiration - 10L);
    }

    @Override
    public String toString() {
        String s = String.format("IamTokenData: accessToken=%s expiration=%d expiresIn=%d", this.accessToken, this.expiration, this.expiresIn);
        return s;
    }
}

