/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.model;

import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileWithMetadata {
    private InputStream data;
    private String filename;
    private String contentType;

    private FileWithMetadata(Builder builder) {
        Validator.notNull(builder.data, "data cannot be null");
        this.data = builder.data;
        this.filename = builder.filename;
        this.contentType = builder.contentType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream data() {
        return this.data;
    }

    public String filename() {
        return this.filename;
    }

    public String contentType() {
        return this.contentType;
    }

    public static class Builder {
        private InputStream data;
        private String filename;
        private String contentType;

        private Builder(FileWithMetadata fileWithMetadata) {
            this.data = fileWithMetadata.data;
            this.filename = fileWithMetadata.filename;
            this.contentType = fileWithMetadata.contentType;
        }

        public Builder() {
        }

        public Builder(InputStream data) {
            this.data = data;
        }

        public Builder(File file) throws FileNotFoundException {
            this.data(file);
        }

        public FileWithMetadata build() {
            return new FileWithMetadata(this);
        }

        public Builder data(InputStream data) {
            this.data = data;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder data(File file) throws FileNotFoundException {
            this.data = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

