/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class ObservableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final ObservableSource<B> boundary;
    final Callable<U> bufferSupplier;

    public ObservableBufferExactBoundary(ObservableSource<T> source2, ObservableSource<B> boundary, Callable<U> bufferSupplier) {
        super(source2);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new BufferExactBoundaryObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundaryObserver<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferExactBoundaryObserver<T, U, B> parent;

        BufferBoundaryObserver(BufferExactBoundaryObserver<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundaryObserver<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Observer<T>,
    Disposable {
        final Callable<U> bufferSupplier;
        final ObservableSource<B> boundary;
        Disposable upstream;
        Disposable other;
        U buffer;

        BufferExactBoundaryObserver(Observer<? super U> actual, Callable<U> bufferSupplier, ObservableSource<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                BufferBoundaryObserver bs;
                Collection b;
                this.upstream = d;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancelled = true;
                    d.dispose();
                    EmptyDisposable.error(e, this.downstream);
                    return;
                }
                this.buffer = b;
                this.other = bs = new BufferBoundaryObserver(this);
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    this.boundary.subscribe(bs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.downstream.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.dispose();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.downstream.onError(e);
                return;
            }
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmit(b, false, this);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.downstream.onNext(v);
        }
    }
}

