/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class CouchDbEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CouchDbEndpoint target = (CouchDbEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(CouchDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "createdatabase": 
            case "createDatabase": {
                target.setCreateDatabase(CouchDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "deletes": {
                target.setDeletes(CouchDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(CouchDbEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(CouchDbEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "heartbeat": {
                target.setHeartbeat(CouchDbEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(CouchDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                target.setMaxMessagesPerPoll(CouchDbEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "password": {
                target.setPassword(CouchDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "style": {
                target.setStyle(CouchDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "updates": {
                target.setUpdates(CouchDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                target.setUsername(CouchDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "createdatabase": 
            case "createDatabase": {
                return Boolean.TYPE;
            }
            case "deletes": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "heartbeat": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return Integer.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "style": {
                return String.class;
            }
            case "updates": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CouchDbEndpoint target = (CouchDbEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "createdatabase": 
            case "createDatabase": {
                return target.isCreateDatabase();
            }
            case "deletes": {
                return target.isDeletes();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "heartbeat": {
                return target.getHeartbeat();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return target.getMaxMessagesPerPoll();
            }
            case "password": {
                return target.getPassword();
            }
            case "style": {
                return target.getStyle();
            }
            case "updates": {
                return target.isUpdates();
            }
            case "username": {
                return target.getUsername();
            }
        }
        return null;
    }
}

