/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class HeadDocumentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected String ifNoneMatch;
    protected Boolean latest;
    protected String rev;

    protected HeadDocumentOptions() {
    }

    protected HeadDocumentOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.docId, "docId cannot be empty");
        this.db = builder.db;
        this.docId = builder.docId;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.latest = builder.latest;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public Boolean latest() {
        return this.latest;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String docId;
        private String ifNoneMatch;
        private Boolean latest;
        private String rev;

        private Builder(HeadDocumentOptions headDocumentOptions) {
            this.db = headDocumentOptions.db;
            this.docId = headDocumentOptions.docId;
            this.ifNoneMatch = headDocumentOptions.ifNoneMatch;
            this.latest = headDocumentOptions.latest;
            this.rev = headDocumentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String docId) {
            this.db = db;
            this.docId = docId;
        }

        public HeadDocumentOptions build() {
            return new HeadDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }
    }
}

