/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.BulkGetQueryDocument;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostBulkGetOptions
extends GenericModel {
    protected String db;
    protected List<BulkGetQueryDocument> docs;
    protected Boolean attachments;
    protected Boolean attEncodingInfo;
    protected Boolean latest;
    protected Boolean revs;

    protected PostBulkGetOptions() {
    }

    protected PostBulkGetOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notNull(builder.docs, "docs cannot be null");
        this.db = builder.db;
        this.docs = builder.docs;
        this.attachments = builder.attachments;
        this.attEncodingInfo = builder.attEncodingInfo;
        this.latest = builder.latest;
        this.revs = builder.revs;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public List<BulkGetQueryDocument> docs() {
        return this.docs;
    }

    public Boolean attachments() {
        return this.attachments;
    }

    public Boolean attEncodingInfo() {
        return this.attEncodingInfo;
    }

    public Boolean latest() {
        return this.latest;
    }

    public Boolean revs() {
        return this.revs;
    }

    public static class Builder {
        private String db;
        private List<BulkGetQueryDocument> docs;
        private Boolean attachments;
        private Boolean attEncodingInfo;
        private Boolean latest;
        private Boolean revs;

        private Builder(PostBulkGetOptions postBulkGetOptions) {
            this.db = postBulkGetOptions.db;
            this.docs = postBulkGetOptions.docs;
            this.attachments = postBulkGetOptions.attachments;
            this.attEncodingInfo = postBulkGetOptions.attEncodingInfo;
            this.latest = postBulkGetOptions.latest;
            this.revs = postBulkGetOptions.revs;
        }

        public Builder() {
        }

        public Builder(String db, List<BulkGetQueryDocument> docs) {
            this.db = db;
            this.docs = docs;
        }

        public PostBulkGetOptions build() {
            return new PostBulkGetOptions(this);
        }

        public Builder addDocs(BulkGetQueryDocument docs) {
            Validator.notNull(docs, "docs cannot be null");
            if (this.docs == null) {
                this.docs = new ArrayList<BulkGetQueryDocument>();
            }
            this.docs.add(docs);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docs(List<BulkGetQueryDocument> docs) {
            this.docs = docs;
            return this;
        }

        public Builder attachments(Boolean attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attEncodingInfo(Boolean attEncodingInfo) {
            this.attEncodingInfo = attEncodingInfo;
            return this;
        }

        public Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public Builder revs(Boolean revs) {
            this.revs = revs;
            return this;
        }
    }
}

