/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PutCorsConfigurationOptions
extends GenericModel {
    protected List<String> origins;
    protected Boolean allowCredentials;
    protected Boolean enableCors;

    protected PutCorsConfigurationOptions() {
    }

    protected PutCorsConfigurationOptions(Builder builder) {
        Validator.notNull(builder.origins, "origins cannot be null");
        this.origins = builder.origins;
        this.allowCredentials = builder.allowCredentials;
        this.enableCors = builder.enableCors;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> origins() {
        return this.origins;
    }

    public Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public Boolean enableCors() {
        return this.enableCors;
    }

    public static class Builder {
        private List<String> origins;
        private Boolean allowCredentials;
        private Boolean enableCors;

        private Builder(PutCorsConfigurationOptions putCorsConfigurationOptions) {
            this.origins = putCorsConfigurationOptions.origins;
            this.allowCredentials = putCorsConfigurationOptions.allowCredentials;
            this.enableCors = putCorsConfigurationOptions.enableCors;
        }

        public Builder() {
        }

        public Builder(List<String> origins) {
            this.origins = origins;
        }

        public PutCorsConfigurationOptions build() {
            return new PutCorsConfigurationOptions(this);
        }

        public Builder addOrigins(String origins) {
            Validator.notNull(origins, "origins cannot be null");
            if (this.origins == null) {
                this.origins = new ArrayList<String>();
            }
            this.origins.add(origins);
            return this;
        }

        public Builder origins(List<String> origins) {
            this.origins = origins;
            return this;
        }

        public Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public Builder enableCors(Boolean enableCors) {
            this.enableCors = enableCors;
            return this;
        }
    }
}

