/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class HeadLocalDocumentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected String ifNoneMatch;

    protected HeadLocalDocumentOptions() {
    }

    protected HeadLocalDocumentOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.docId, "docId cannot be empty");
        this.db = builder.db;
        this.docId = builder.docId;
        this.ifNoneMatch = builder.ifNoneMatch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder {
        private String db;
        private String docId;
        private String ifNoneMatch;

        private Builder(HeadLocalDocumentOptions headLocalDocumentOptions) {
            this.db = headLocalDocumentOptions.db;
            this.docId = headLocalDocumentOptions.docId;
            this.ifNoneMatch = headLocalDocumentOptions.ifNoneMatch;
        }

        public Builder() {
        }

        public Builder(String db, String docId) {
            this.db = db;
            this.docId = docId;
        }

        public HeadLocalDocumentOptions build() {
            return new HeadLocalDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }
    }
}

