/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.cloudant.v1.model.Analyzer;
import com.ibm.cloud.cloudant.v1.model.IndexField;
import com.ibm.cloud.cloudant.v1.model.IndexTextOperatorDefaultField;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IndexDefinition
extends GenericModel {
    @SerializedName(value="default_analyzer")
    protected Analyzer defaultAnalyzer;
    @SerializedName(value="default_field")
    protected IndexTextOperatorDefaultField defaultField;
    protected List<IndexField> fields;
    @SerializedName(value="index_array_lengths")
    protected Boolean indexArrayLengths;
    @SerializedName(value="partial_filter_selector")
    protected Map<String, Object> partialFilterSelector;

    protected IndexDefinition() {
    }

    protected IndexDefinition(Builder builder) {
        this.defaultAnalyzer = builder.defaultAnalyzer;
        this.defaultField = builder.defaultField;
        this.fields = builder.fields;
        this.indexArrayLengths = builder.indexArrayLengths;
        this.partialFilterSelector = builder.partialFilterSelector;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public IndexTextOperatorDefaultField defaultField() {
        return this.defaultField;
    }

    public List<IndexField> fields() {
        return this.fields;
    }

    public Boolean indexArrayLengths() {
        return this.indexArrayLengths;
    }

    public Map<String, Object> partialFilterSelector() {
        return this.partialFilterSelector;
    }

    public static class Builder {
        private Analyzer defaultAnalyzer;
        private IndexTextOperatorDefaultField defaultField;
        private List<IndexField> fields;
        private Boolean indexArrayLengths;
        private Map<String, Object> partialFilterSelector;

        private Builder(IndexDefinition indexDefinition) {
            this.defaultAnalyzer = indexDefinition.defaultAnalyzer;
            this.defaultField = indexDefinition.defaultField;
            this.fields = indexDefinition.fields;
            this.indexArrayLengths = indexDefinition.indexArrayLengths;
            this.partialFilterSelector = indexDefinition.partialFilterSelector;
        }

        public Builder() {
        }

        public IndexDefinition build() {
            return new IndexDefinition(this);
        }

        public Builder addFields(IndexField fields) {
            Validator.notNull(fields, "fields cannot be null");
            if (this.fields == null) {
                this.fields = new ArrayList<IndexField>();
            }
            this.fields.add(fields);
            return this;
        }

        public Builder defaultAnalyzer(Analyzer defaultAnalyzer) {
            this.defaultAnalyzer = defaultAnalyzer;
            return this;
        }

        public Builder defaultField(IndexTextOperatorDefaultField defaultField) {
            this.defaultField = defaultField;
            return this;
        }

        public Builder fields(List<IndexField> fields) {
            this.fields = fields;
            return this;
        }

        public Builder indexArrayLengths(Boolean indexArrayLengths) {
            this.indexArrayLengths = indexArrayLengths;
            return this;
        }

        public Builder partialFilterSelector(Map<String, Object> partialFilterSelector) {
            this.partialFilterSelector = partialFilterSelector;
            return this;
        }
    }
}

