/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostPartitionViewOptions
extends GenericModel {
    protected String db;
    protected String partitionKey;
    protected String ddoc;
    protected String view;
    protected Boolean attEncodingInfo;
    protected Boolean attachments;
    protected Boolean conflicts;
    protected Boolean descending;
    protected Boolean includeDocs;
    protected Boolean inclusiveEnd;
    protected Long limit;
    protected Long skip;
    protected Boolean updateSeq;
    protected Object endKey;
    protected String endKeyDocId;
    protected Boolean group;
    protected Long groupLevel;
    protected Object key;
    protected List<Object> keys;
    protected Boolean reduce;
    protected Object startKey;
    protected String startKeyDocId;
    protected String update;

    protected PostPartitionViewOptions() {
    }

    protected PostPartitionViewOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.partitionKey, "partitionKey cannot be empty");
        Validator.notEmpty(builder.ddoc, "ddoc cannot be empty");
        Validator.notEmpty(builder.view, "view cannot be empty");
        this.db = builder.db;
        this.partitionKey = builder.partitionKey;
        this.ddoc = builder.ddoc;
        this.view = builder.view;
        this.attEncodingInfo = builder.attEncodingInfo;
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.descending = builder.descending;
        this.includeDocs = builder.includeDocs;
        this.inclusiveEnd = builder.inclusiveEnd;
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.updateSeq = builder.updateSeq;
        this.endKey = builder.endKey;
        this.endKeyDocId = builder.endKeyDocId;
        this.group = builder.group;
        this.groupLevel = builder.groupLevel;
        this.key = builder.key;
        this.keys = builder.keys;
        this.reduce = builder.reduce;
        this.startKey = builder.startKey;
        this.startKeyDocId = builder.startKeyDocId;
        this.update = builder.update;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String view() {
        return this.view;
    }

    public Boolean attEncodingInfo() {
        return this.attEncodingInfo;
    }

    public Boolean attachments() {
        return this.attachments;
    }

    public Boolean conflicts() {
        return this.conflicts;
    }

    public Boolean descending() {
        return this.descending;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public Boolean inclusiveEnd() {
        return this.inclusiveEnd;
    }

    public Long limit() {
        return this.limit;
    }

    public Long skip() {
        return this.skip;
    }

    public Boolean updateSeq() {
        return this.updateSeq;
    }

    public Object endKey() {
        return this.endKey;
    }

    public String endKeyDocId() {
        return this.endKeyDocId;
    }

    public Boolean group() {
        return this.group;
    }

    public Long groupLevel() {
        return this.groupLevel;
    }

    public Object key() {
        return this.key;
    }

    public List<Object> keys() {
        return this.keys;
    }

    public Boolean reduce() {
        return this.reduce;
    }

    public Object startKey() {
        return this.startKey;
    }

    public String startKeyDocId() {
        return this.startKeyDocId;
    }

    public String update() {
        return this.update;
    }

    public static class Builder {
        private String db;
        private String partitionKey;
        private String ddoc;
        private String view;
        private Boolean attEncodingInfo;
        private Boolean attachments;
        private Boolean conflicts;
        private Boolean descending;
        private Boolean includeDocs;
        private Boolean inclusiveEnd;
        private Long limit;
        private Long skip;
        private Boolean updateSeq;
        private Object endKey;
        private String endKeyDocId;
        private Boolean group;
        private Long groupLevel;
        private Object key;
        private List<Object> keys;
        private Boolean reduce;
        private Object startKey;
        private String startKeyDocId;
        private String update;

        private Builder(PostPartitionViewOptions postPartitionViewOptions) {
            this.db = postPartitionViewOptions.db;
            this.partitionKey = postPartitionViewOptions.partitionKey;
            this.ddoc = postPartitionViewOptions.ddoc;
            this.view = postPartitionViewOptions.view;
            this.attEncodingInfo = postPartitionViewOptions.attEncodingInfo;
            this.attachments = postPartitionViewOptions.attachments;
            this.conflicts = postPartitionViewOptions.conflicts;
            this.descending = postPartitionViewOptions.descending;
            this.includeDocs = postPartitionViewOptions.includeDocs;
            this.inclusiveEnd = postPartitionViewOptions.inclusiveEnd;
            this.limit = postPartitionViewOptions.limit;
            this.skip = postPartitionViewOptions.skip;
            this.updateSeq = postPartitionViewOptions.updateSeq;
            this.endKey = postPartitionViewOptions.endKey;
            this.endKeyDocId = postPartitionViewOptions.endKeyDocId;
            this.group = postPartitionViewOptions.group;
            this.groupLevel = postPartitionViewOptions.groupLevel;
            this.key = postPartitionViewOptions.key;
            this.keys = postPartitionViewOptions.keys;
            this.reduce = postPartitionViewOptions.reduce;
            this.startKey = postPartitionViewOptions.startKey;
            this.startKeyDocId = postPartitionViewOptions.startKeyDocId;
            this.update = postPartitionViewOptions.update;
        }

        public Builder() {
        }

        public Builder(String db, String partitionKey, String ddoc, String view) {
            this.db = db;
            this.partitionKey = partitionKey;
            this.ddoc = ddoc;
            this.view = view;
        }

        public PostPartitionViewOptions build() {
            return new PostPartitionViewOptions(this);
        }

        public Builder addKeys(Object keys2) {
            Validator.notNull(keys2, "keys cannot be null");
            if (this.keys == null) {
                this.keys = new ArrayList<Object>();
            }
            this.keys.add(keys2);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder view(String view) {
            this.view = view;
            return this;
        }

        public Builder attEncodingInfo(Boolean attEncodingInfo) {
            this.attEncodingInfo = attEncodingInfo;
            return this;
        }

        public Builder attachments(Boolean attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(Boolean conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder inclusiveEnd(Boolean inclusiveEnd) {
            this.inclusiveEnd = inclusiveEnd;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder updateSeq(Boolean updateSeq) {
            this.updateSeq = updateSeq;
            return this;
        }

        public Builder endKey(Object endKey) {
            this.endKey = endKey;
            return this;
        }

        public Builder endKeyDocId(String endKeyDocId) {
            this.endKeyDocId = endKeyDocId;
            return this;
        }

        public Builder group(Boolean group) {
            this.group = group;
            return this;
        }

        public Builder groupLevel(long groupLevel) {
            this.groupLevel = groupLevel;
            return this;
        }

        public Builder key(Object key) {
            this.key = key;
            return this;
        }

        public Builder keys(List<Object> keys2) {
            this.keys = keys2;
            return this;
        }

        public Builder reduce(Boolean reduce) {
            this.reduce = reduce;
            return this;
        }

        public Builder startKey(Object startKey) {
            this.startKey = startKey;
            return this;
        }

        public Builder startKeyDocId(String startKeyDocId) {
            this.startKeyDocId = startKeyDocId;
            return this;
        }

        public Builder update(String update) {
            this.update = update;
            return this;
        }
    }

    public static interface Update {
        public static final String X_TRUE = "true";
        public static final String X_FALSE = "false";
        public static final String LAZY = "lazy";
    }
}

