/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.observers.ResumeSingleObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleDelayWithObservable<T, U>
extends Single<T> {
    final SingleSource<T> source;
    final ObservableSource<U> other;

    public SingleDelayWithObservable(SingleSource<T> source2, ObservableSource<U> other) {
        this.source = source2;
        this.other = other;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.other.subscribe(new OtherSubscriber(observer, this.source));
    }

    static final class OtherSubscriber<T, U>
    extends AtomicReference<Disposable>
    implements Observer<U>,
    Disposable {
        private static final long serialVersionUID = -8565274649390031272L;
        final SingleObserver<? super T> downstream;
        final SingleSource<T> source;
        boolean done;

        OtherSubscriber(SingleObserver<? super T> actual, SingleSource<T> source2) {
            this.downstream = actual;
            this.source = source2;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.set(this, d)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(U value) {
            ((Disposable)this.get()).dispose();
            this.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.source.subscribe(new ResumeSingleObserver<T>(this, this.downstream));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }
}

