/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExecutorServiceManager
extends ServiceSupport
implements ExecutorServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExecutorServiceManager.class);
    private final CamelContext camelContext;
    private final List<ExecutorService> executorServices = new CopyOnWriteArrayList<ExecutorService>();
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new ConcurrentHashMap<String, ThreadPoolProfile>();
    private final List<ExecutorServiceManager.ThreadFactoryListener> threadFactoryListeners = new CopyOnWriteArrayList<ExecutorServiceManager.ThreadFactoryListener>();
    private ThreadPoolFactory threadPoolFactory;
    private String threadNamePattern;
    private long shutdownAwaitTermination = 10000L;
    private String defaultThreadPoolProfileId = "defaultThreadPoolProfile";
    private final ThreadPoolProfile defaultProfile;

    public BaseExecutorServiceManager(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.defaultProfile = new ThreadPoolProfile(this.defaultThreadPoolProfileId);
        this.defaultProfile.setDefaultProfile(true);
        this.defaultProfile.setPoolSize(10);
        this.defaultProfile.setMaxPoolSize(20);
        this.defaultProfile.setKeepAliveTime(60L);
        this.defaultProfile.setTimeUnit(TimeUnit.SECONDS);
        this.defaultProfile.setMaxQueueSize(1000);
        this.defaultProfile.setAllowCoreThreadTimeOut(true);
        this.defaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(this.defaultProfile);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void addThreadFactoryListener(ExecutorServiceManager.ThreadFactoryListener threadFactoryListener) {
        this.threadFactoryListeners.add(threadFactoryListener);
    }

    @Override
    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public void setThreadPoolFactory(ThreadPoolFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
    }

    @Override
    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        ObjectHelper.notNull(profile, "profile");
        StringHelper.notEmpty(profile.getId(), "id", profile);
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    @Override
    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    @Override
    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        defaultThreadPoolProfile.addDefaults(this.defaultProfile);
        LOG.info("Using custom DefaultThreadPoolProfile: {}", (Object)defaultThreadPoolProfile);
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(true);
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    @Override
    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern != null ? threadNamePattern.replace("#camelId#", this.camelContext.getName()) : threadNamePattern;
    }

    @Override
    public long getShutdownAwaitTermination() {
        return this.shutdownAwaitTermination;
    }

    @Override
    public void setShutdownAwaitTermination(long shutdownAwaitTermination) {
        this.shutdownAwaitTermination = shutdownAwaitTermination;
    }

    @Override
    public String resolveThreadName(String name) {
        return ThreadHelper.resolveThreadName(this.threadNamePattern, name);
    }

    @Override
    public Thread newThread(String name, Runnable runnable2) {
        ThreadFactory factory2 = this.createThreadFactory(name, true);
        return factory2.newThread(runnable2);
    }

    @Override
    public ExecutorService newDefaultThreadPool(Object source2, String name) {
        return this.newThreadPool(source2, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ScheduledExecutorService newDefaultScheduledThreadPool(Object source2, String name) {
        return this.newScheduledThreadPool(source2, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ExecutorService newThreadPool(Object source2, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newThreadPool(source2, name, profile);
        }
        return null;
    }

    @Override
    public ExecutorService newThreadPool(Object source2, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ObjectHelper.notNull(profile, "ThreadPoolProfile");
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        profile.addDefaults(defaultProfile);
        ThreadFactory threadFactory = this.createThreadFactory(sanitizedName, true);
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(profile, threadFactory);
        this.onThreadPoolCreated(executorService, source2, profile.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ThreadPool for source: {} with name: {}. -> {}", new Object[]{source2, sanitizedName, executorService});
        }
        return executorService;
    }

    @Override
    public ExecutorService newThreadPool(Object source2, String name, int poolSize, int maxPoolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(maxPoolSize);
        return this.newThreadPool(source2, name, profile);
    }

    @Override
    public ExecutorService newSingleThreadExecutor(Object source2, String name) {
        return this.newFixedThreadPool(source2, name, 1);
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source2, String name) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ExecutorService answer = this.threadPoolFactory.newCachedThreadPool(this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source2, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new CachedThreadPool for source: {} with name: {}. -> {}", new Object[]{source2, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newFixedThreadPool(Object source2, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(poolSize);
        profile.setKeepAliveTime(0L);
        profile.setAllowCoreThreadTimeOut(false);
        return this.newThreadPool(source2, name, profile);
    }

    @Override
    public ScheduledExecutorService newSingleThreadScheduledExecutor(Object source2, String name) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(1);
        profile.setMaxPoolSize(1);
        profile.setKeepAliveTime(0L);
        profile.setAllowCoreThreadTimeOut(false);
        return this.newScheduledThreadPool(source2, name, profile);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source2, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        profile.addDefaults(this.getDefaultThreadPoolProfile());
        ScheduledExecutorService answer = this.threadPoolFactory.newScheduledThreadPool(profile, this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source2, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ScheduledThreadPool for source: {} with name: {} -> {}", new Object[]{source2, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source2, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newScheduledThreadPool(source2, name, profile);
        }
        return null;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source2, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        return this.newScheduledThreadPool(source2, name, profile);
    }

    @Override
    public void shutdown(ExecutorService executorService) {
        this.doShutdown(executorService, 0L, false);
    }

    @Override
    public void shutdownGraceful(ExecutorService executorService) {
        this.doShutdown(executorService, this.getShutdownAwaitTermination(), false);
    }

    @Override
    public void shutdownGraceful(ExecutorService executorService, long shutdownAwaitTermination) {
        this.doShutdown(executorService, shutdownAwaitTermination, false);
    }

    private boolean doShutdown(ExecutorService executorService, long shutdownAwaitTermination, boolean failSafe) {
        if (executorService == null) {
            return false;
        }
        boolean warned = false;
        if (!executorService.isShutdown()) {
            StopWatch watch = new StopWatch();
            LOG.trace("Shutdown of ExecutorService: {} with await termination: {} millis", (Object)executorService, (Object)shutdownAwaitTermination);
            executorService.shutdown();
            if (shutdownAwaitTermination > 0L) {
                try {
                    if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                        warned = true;
                        LOG.warn("Forcing shutdown of ExecutorService: {} due first await termination elapsed.", (Object)executorService);
                        executorService.shutdownNow();
                        if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                            LOG.warn("Cannot completely force shutdown of ExecutorService: {} due second await termination elapsed.", (Object)executorService);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    warned = true;
                    LOG.warn("Forcing shutdown of ExecutorService: {} due interrupted.", (Object)executorService);
                    executorService.shutdownNow();
                }
            }
            if (warned) {
                LOG.info("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken(), true)});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken(), true)});
            }
        }
        this.doRemove(executorService, failSafe);
        return warned;
    }

    private void doRemove(ExecutorService executorService, boolean failSafe) {
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor;
            threadPool = threadPoolExecutor = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            SizedScheduledExecutorService sizedScheduledExecutorService = (SizedScheduledExecutorService)executorService;
            threadPool = sizedScheduledExecutorService.getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolRemove(this.camelContext, threadPool);
            }
        }
        if (!failSafe) {
            this.executorServices.remove(executorService);
        }
    }

    @Override
    public List<Runnable> shutdownNow(ExecutorService executorService) {
        return this.doShutdownNow(executorService);
    }

    private List<Runnable> doShutdownNow(ExecutorService executorService) {
        ObjectHelper.notNull(executorService, "executorService");
        List<Runnable> answer = null;
        if (!executorService.isShutdown()) {
            LOG.debug("Forcing shutdown of ExecutorService: {}", (Object)executorService);
            answer = executorService.shutdownNow();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated()});
            }
        }
        this.doRemove(executorService, false);
        return answer;
    }

    @Override
    public boolean awaitTermination(ExecutorService executorService, long shutdownAwaitTermination) throws InterruptedException {
        StopWatch watch = new StopWatch();
        long interval = Math.min(2000L, shutdownAwaitTermination);
        boolean done = false;
        while (!done && interval > 0L) {
            if (executorService.awaitTermination(interval, TimeUnit.MILLISECONDS)) {
                done = true;
                continue;
            }
            LOG.info("Waited {} for ExecutorService: {} to terminate...", (Object)TimeUtils.printDuration(watch.taken(), true), (Object)executorService);
            interval = Math.min(2000L, shutdownAwaitTermination - watch.taken());
        }
        return done;
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.threadNamePattern == null) {
            this.threadNamePattern = "Camel (" + this.camelContext.getName() + ") thread ##counter# - #name#";
        }
        if (this.threadPoolFactory == null) {
            this.threadPoolFactory = ResolverHelper.resolveService(this.camelContext, this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), "thread-pool-factory", ThreadPoolFactory.class).orElseGet(DefaultThreadPoolFactory::new);
        }
        CamelContextAware.trySetCamelContext(this.threadPoolFactory, this.camelContext);
        ServiceHelper.initService((Object)this.threadPoolFactory);
        ResolverHelper.resolveService(this.camelContext, this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), "thread-factory-listener", ExecutorServiceManager.ThreadFactoryListener.class).ifPresent(this::addThreadFactoryListener);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Set<ExecutorServiceManager.ThreadFactoryListener> listeners = this.camelContext.getRegistry().findByType(ExecutorServiceManager.ThreadFactoryListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            this.threadFactoryListeners.addAll(listeners);
        }
        if (!this.threadFactoryListeners.isEmpty()) {
            this.threadFactoryListeners.sort(OrderedComparator.get());
        }
        ServiceHelper.startService((Object)this.threadPoolFactory);
    }

    @Override
    protected void doShutdown() throws Exception {
        LinkedHashSet<ExecutorService> forced = new LinkedHashSet<ExecutorService>();
        if (!this.executorServices.isEmpty()) {
            LOG.debug("Giving time for {} ExecutorService's to shutdown properly (acting as fail-safe)", (Object)this.executorServices.size());
            for (ExecutorService executorService : this.executorServices) {
                try {
                    boolean warned = this.doShutdown(executorService, this.getShutdownAwaitTermination(), true);
                    if (!warned) continue;
                    forced.add(executorService);
                }
                catch (Exception e) {
                    LOG.warn("Error occurred during shutdown of ExecutorService: {}. This exception will be ignored.", (Object)executorService, (Object)e);
                }
            }
        }
        if (!forced.isEmpty()) {
            LOG.warn("Forced shutdown of {} ExecutorService's which has not been shutdown properly (acting as fail-safe)", (Object)forced.size());
            for (ExecutorService executorService : forced) {
                LOG.warn("  forced -> {}", (Object)executorService);
            }
        }
        forced.clear();
        this.executorServices.clear();
        Iterator<ThreadPoolProfile> it = this.threadPoolProfiles.values().iterator();
        while (it.hasNext()) {
            ThreadPoolProfile profile = it.next();
            if (profile.isDefaultProfile().booleanValue()) continue;
            it.remove();
        }
        ServiceHelper.stopAndShutdownServices(this.threadPoolFactory);
        this.threadFactoryListeners.clear();
    }

    private void onThreadPoolCreated(ExecutorService executorService, Object source2, String threadPoolProfileId) {
        Object id;
        NamedNode namedNode;
        this.executorServices.add(executorService);
        String sourceId = null;
        String routeId = null;
        if (source2 instanceof NamedNode) {
            namedNode = (NamedNode)source2;
            id = namedNode.getId();
            sourceId = namedNode.getShortName();
        } else if (source2 instanceof String) {
            String str = (String)source2;
            id = str;
        } else {
            id = source2 != null ? (source2 instanceof StaticService ? source2.getClass().getSimpleName() : source2.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(source2) + ")") : executorService.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(executorService) + ")";
        }
        StringHelper.notEmpty((String)id, "id for thread pool " + String.valueOf(executorService));
        if (source2 instanceof NamedNode) {
            namedNode = (NamedNode)source2;
            routeId = CamelContextHelper.getRouteId(namedNode);
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor;
            threadPool = threadPoolExecutor = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            SizedScheduledExecutorService scheduledExecutorService = (SizedScheduledExecutorService)executorService;
            threadPool = scheduledExecutorService.getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool, (String)id, sourceId, routeId, threadPoolProfileId);
            }
        }
        this.onNewExecutorService(executorService);
    }

    protected ThreadFactory createThreadFactory(String name, boolean daemon) {
        ThreadFactory factory2 = new CamelThreadFactory(this.threadNamePattern, name, daemon);
        for (ExecutorServiceManager.ThreadFactoryListener listener : this.threadFactoryListeners) {
            factory2 = listener.onNewThreadFactory(factory2);
        }
        return factory2;
    }
}

