/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.engine.DefaultSupervisingRouteController;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultRouteController
extends ServiceSupport
implements RouteController,
NonManagedService {
    private CamelContext camelContext;
    private LoggingLevel loggingLevel = LoggingLevel.DEBUG;

    public DefaultRouteController() {
        this(null);
    }

    public DefaultRouteController(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    @Override
    public boolean isSupervising() {
        return this instanceof SupervisingRouteController;
    }

    protected RouteController getInternalRouteController() {
        return this.camelContext.getCamelContextExtension().getInternalRouteController();
    }

    @Override
    public void startAllRoutes() throws Exception {
        this.getInternalRouteController().startAllRoutes();
    }

    @Override
    public void stopAllRoutes() throws Exception {
        this.getInternalRouteController().stopAllRoutes();
    }

    @Override
    public void removeAllRoutes() throws Exception {
        this.getInternalRouteController().removeAllRoutes();
    }

    @Override
    public boolean isStartingRoutes() {
        return this.getInternalRouteController().isStartingRoutes();
    }

    @Override
    public boolean hasUnhealthyRoutes() {
        return this.getInternalRouteController().hasUnhealthyRoutes();
    }

    @Override
    public void reloadAllRoutes() throws Exception {
        this.getInternalRouteController().reloadAllRoutes();
    }

    @Override
    public boolean isReloadingRoutes() {
        return this.getInternalRouteController().isReloadingRoutes();
    }

    @Override
    public ServiceStatus getRouteStatus(String routeId) {
        return this.getInternalRouteController().getRouteStatus(routeId);
    }

    @Override
    public void startRoute(String routeId) throws Exception {
        this.getInternalRouteController().startRoute(routeId);
    }

    @Override
    public void stopRoute(String routeId) throws Exception {
        this.getInternalRouteController().stopRoute(routeId);
    }

    @Override
    public void stopRoute(String routeId, Throwable cause) throws Exception {
        this.getInternalRouteController().stopRoute(routeId, cause);
    }

    @Override
    public void stopRoute(String routeId, long timeout2, TimeUnit timeUnit) throws Exception {
        this.getInternalRouteController().stopRoute(routeId, timeout2, timeUnit);
    }

    @Override
    public boolean stopRoute(String routeId, long timeout2, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        return this.getInternalRouteController().stopRoute(routeId, timeout2, timeUnit, abortAfterTimeout);
    }

    @Override
    public void suspendRoute(String routeId) throws Exception {
        this.getInternalRouteController().suspendRoute(routeId);
    }

    @Override
    public void suspendRoute(String routeId, long timeout2, TimeUnit timeUnit) throws Exception {
        this.getInternalRouteController().suspendRoute(routeId, timeout2, timeUnit);
    }

    @Override
    public void resumeRoute(String routeId) throws Exception {
        this.getInternalRouteController().resumeRoute(routeId);
    }

    @Override
    public <T extends RouteController> T adapt(Class<T> type) {
        return (T)((RouteController)type.cast(this));
    }

    @Override
    public SupervisingRouteController supervising() {
        DefaultRouteController defaultRouteController = this;
        if (defaultRouteController instanceof SupervisingRouteController) {
            SupervisingRouteController src = (SupervisingRouteController)((Object)defaultRouteController);
            return src;
        }
        DefaultSupervisingRouteController src = new DefaultSupervisingRouteController();
        src.setCamelContext(this.camelContext);
        this.camelContext.setRouteController(src);
        return src;
    }

    @Override
    public Collection<Route> getControlledRoutes() {
        return Collections.emptyList();
    }
}

