/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cron;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cron.CronComponent;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.1.0", scheme="cron", title="Cron", syntax="cron:name", consumerOnly=true, remote=false, category={Category.SCHEDULING})
public class CronEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private Endpoint delegate;
    @UriParam
    private CamelCronConfiguration configuration;

    public CronEndpoint(String endpointUri, CronComponent component, CamelCronConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void setDelegate(Endpoint delegate) {
        this.delegate = delegate;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.delegate;
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        Consumer consumer = this.delegate.createConsumer(processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public CamelCronConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull(this.delegate, "delegate endpoint");
        ServiceHelper.startService(this.delegate);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.delegate);
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        ServiceHelper.stopAndShutdownService(this.delegate);
    }
}

