/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.DigitalSignatureComponent;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;

public class DigitalSignatureComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DigitalSignatureConfiguration getOrCreateConfiguration(DigitalSignatureComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DigitalSignatureConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DigitalSignatureComponent target = (DigitalSignatureComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                this.getOrCreateConfiguration(target).setAlgorithm(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "alias": {
                this.getOrCreateConfiguration(target).setAlias(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(DigitalSignatureComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                this.getOrCreateConfiguration(target).setBufferSize(DigitalSignatureComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "certificate": {
                this.getOrCreateConfiguration(target).setCertificate(DigitalSignatureComponentConfigurer.property(camelContext, Certificate.class, value));
                return true;
            }
            case "certificatename": 
            case "certificateName": {
                this.getOrCreateConfiguration(target).setCertificateName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clearheaders": 
            case "clearHeaders": {
                this.getOrCreateConfiguration(target).setClearHeaders(DigitalSignatureComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(DigitalSignatureComponentConfigurer.property(camelContext, DigitalSignatureConfiguration.class, value));
                return true;
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                this.getOrCreateConfiguration(target).setKeyStoreParameters(DigitalSignatureComponentConfigurer.property(camelContext, KeyStoreParameters.class, value));
                return true;
            }
            case "keystore": {
                this.getOrCreateConfiguration(target).setKeystore(DigitalSignatureComponentConfigurer.property(camelContext, KeyStore.class, value));
                return true;
            }
            case "keystorename": 
            case "keystoreName": {
                this.getOrCreateConfiguration(target).setKeystoreName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DigitalSignatureComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "privatekey": 
            case "privateKey": {
                this.getOrCreateConfiguration(target).setPrivateKey(DigitalSignatureComponentConfigurer.property(camelContext, PrivateKey.class, value));
                return true;
            }
            case "privatekeyname": 
            case "privateKeyName": {
                this.getOrCreateConfiguration(target).setPrivateKeyName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "provider": {
                this.getOrCreateConfiguration(target).setProvider(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "publickey": 
            case "publicKey": {
                this.getOrCreateConfiguration(target).setPublicKey(DigitalSignatureComponentConfigurer.property(camelContext, PublicKey.class, value));
                return true;
            }
            case "publickeyname": 
            case "publicKeyName": {
                this.getOrCreateConfiguration(target).setPublicKeyName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "securerandom": 
            case "secureRandom": {
                this.getOrCreateConfiguration(target).setSecureRandom(DigitalSignatureComponentConfigurer.property(camelContext, SecureRandom.class, value));
                return true;
            }
            case "securerandomname": 
            case "secureRandomName": {
                this.getOrCreateConfiguration(target).setSecureRandomName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                this.getOrCreateConfiguration(target).setSignatureHeaderName(DigitalSignatureComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return String.class;
            }
            case "alias": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "buffersize": 
            case "bufferSize": {
                return Integer.class;
            }
            case "certificate": {
                return Certificate.class;
            }
            case "certificatename": 
            case "certificateName": {
                return String.class;
            }
            case "clearheaders": 
            case "clearHeaders": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return DigitalSignatureConfiguration.class;
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                return KeyStoreParameters.class;
            }
            case "keystore": {
                return KeyStore.class;
            }
            case "keystorename": 
            case "keystoreName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "privatekey": 
            case "privateKey": {
                return PrivateKey.class;
            }
            case "privatekeyname": 
            case "privateKeyName": {
                return String.class;
            }
            case "provider": {
                return String.class;
            }
            case "publickey": 
            case "publicKey": {
                return PublicKey.class;
            }
            case "publickeyname": 
            case "publicKeyName": {
                return String.class;
            }
            case "securerandom": 
            case "secureRandom": {
                return SecureRandom.class;
            }
            case "securerandomname": 
            case "secureRandomName": {
                return String.class;
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DigitalSignatureComponent target = (DigitalSignatureComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return this.getOrCreateConfiguration(target).getAlgorithm();
            }
            case "alias": {
                return this.getOrCreateConfiguration(target).getAlias();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "buffersize": 
            case "bufferSize": {
                return this.getOrCreateConfiguration(target).getBufferSize();
            }
            case "certificate": {
                return this.getOrCreateConfiguration(target).getCertificate();
            }
            case "certificatename": 
            case "certificateName": {
                return this.getOrCreateConfiguration(target).getCertificateName();
            }
            case "clearheaders": 
            case "clearHeaders": {
                return this.getOrCreateConfiguration(target).isClearHeaders();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                return this.getOrCreateConfiguration(target).getKeyStoreParameters();
            }
            case "keystore": {
                return this.getOrCreateConfiguration(target).getKeystore();
            }
            case "keystorename": 
            case "keystoreName": {
                return this.getOrCreateConfiguration(target).getKeystoreName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "privatekey": 
            case "privateKey": {
                return this.getOrCreateConfiguration(target).getPrivateKey();
            }
            case "privatekeyname": 
            case "privateKeyName": {
                return this.getOrCreateConfiguration(target).getPrivateKeyName();
            }
            case "provider": {
                return this.getOrCreateConfiguration(target).getProvider();
            }
            case "publickey": 
            case "publicKey": {
                return this.getOrCreateConfiguration(target).getPublicKey();
            }
            case "publickeyname": 
            case "publicKeyName": {
                return this.getOrCreateConfiguration(target).getPublicKeyName();
            }
            case "securerandom": 
            case "secureRandom": {
                return this.getOrCreateConfiguration(target).getSecureRandom();
            }
            case "securerandomname": 
            case "secureRandomName": {
                return this.getOrCreateConfiguration(target).getSecureRandomName();
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                return this.getOrCreateConfiguration(target).getSignatureHeaderName();
            }
        }
        return null;
    }
}

