/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.processor;

import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.processor.DigitalSignatureProcessor;
import org.apache.camel.support.ExchangeHelper;
import org.apache.commons.codec.binary.Base64;

public class VerifyingProcessor
extends DigitalSignatureProcessor {
    public VerifyingProcessor(DigitalSignatureConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Signature signer = this.createSignatureService();
        Certificate cert = this.getCertificate(exchange);
        if (cert == null) {
            PublicKey pk = this.getPublicKeyOrCertificateFromHeader(exchange, PublicKey.class, this.config.getPublicKey());
            if (pk == null) {
                throw new IllegalStateException(String.format("Cannot verify signature as no Public Key or Certificate has been supplied. Either supply one in the route definition or via the message header '%s'", "CamelSignaturePublicKeyOrCert"));
            }
            signer.initVerify(pk);
        } else {
            signer.initVerify(cert);
        }
        this.calculateSignature(exchange, signer);
        byte[] signature = this.getSignatureFromExchange(exchange);
        if (!signer.verify(signature)) {
            throw new SignatureException("Cannot verify signature of exchange");
        }
        this.clearMessageHeaders(exchange.getIn());
    }

    private byte[] getSignatureFromExchange(Exchange exchange) throws Exception {
        String encodedSignature = ExchangeHelper.getMandatoryHeader(exchange, this.config.getSignatureHeaderName(), String.class);
        if (encodedSignature == null) {
            throw new IllegalStateException("Cannot verify exchange as no " + this.config.getSignatureHeaderName() + " header is present.");
        }
        return new Base64().decode(encodedSignature);
    }

    private Certificate getCertificate(Exchange exchange) throws Exception {
        Certificate cert = this.config.getCertificate(this.getAlias(exchange));
        return this.getPublicKeyOrCertificateFromHeader(exchange, Certificate.class, cert);
    }

    private <T> T getPublicKeyOrCertificateFromHeader(Exchange exchange, Class<? extends T> verificationType, T defaultsTo) {
        T pkOrCert = exchange.getIn().getHeader("CamelSignaturePublicKeyOrCert", verificationType);
        if (pkOrCert == null) {
            pkOrCert = defaultsTo;
        }
        return pkOrCert;
    }
}

