/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.dataset.DataSetTestEndpoint;
import org.apache.camel.component.mock.MockEndpointConfigurer;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;

public class DataSetTestEndpointConfigurer
extends MockEndpointConfigurer
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DataSetTestEndpoint target = (DataSetTestEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "anyorder": 
            case "anyOrder": {
                target.setAnyOrder(DataSetTestEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delimiter": {
                target.setDelimiter(DataSetTestEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "split": {
                target.setSplit(DataSetTestEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timeout": {
                target.setTimeout(DataSetTestEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
        }
        return super.configure(camelContext, obj, name, value, ignoreCase);
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "anyorder": 
            case "anyOrder": {
                return Boolean.TYPE;
            }
            case "delimiter": {
                return String.class;
            }
            case "split": {
                return Boolean.TYPE;
            }
            case "timeout": {
                return Long.TYPE;
            }
        }
        return super.getOptionType(name, ignoreCase);
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DataSetTestEndpoint target = (DataSetTestEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "anyorder": 
            case "anyOrder": {
                return target.isAnyOrder();
            }
            case "delimiter": {
                return target.getDelimiter();
            }
            case "split": {
                return target.isSplit();
            }
            case "timeout": {
                return target.getTimeout();
            }
        }
        return super.getOptionValue(obj, name, ignoreCase);
    }
}

