/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.plugins.BaseJacksonDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import ujson.Null$;
import ujson.Value;

public class MimeMultipartPlugin
extends BaseJacksonDataFormatPlugin {
    public static final String DS_PARAM_BOUNDARY = "boundary";
    private static final String lineFeed = "\r\n";

    public MimeMultipartPlugin() {
        this.supportedTypes.add(MediaTypes.MULTIPART_FORM_DATA);
        this.supportedTypes.add(MediaTypes.MULTIPART_MIXED);
        this.supportedTypes.add(MediaTypes.MULTIPART_RELATED);
        this.writerParams.add(DS_PARAM_BOUNDARY);
        this.readerParams.add(DS_PARAM_BOUNDARY);
        this.readerSupportedClasses.add(String.class);
        this.readerSupportedClasses.add(InputStream.class);
        this.readerSupportedClasses.add(byte[].class);
        this.writerSupportedClasses.add(String.class);
        this.writerSupportedClasses.add(ByteArrayOutputStream.class);
        this.writerSupportedClasses.add(byte[].class);
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        Map<String, String> params = doc.getMediaType().getParameters();
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        ByteArrayInputStream multipartData = null;
        String boundary = null;
        if (String.class.isAssignableFrom(doc.getContent().getClass())) {
            multipartData = new ByteArrayInputStream(doc.getContent().toString().getBytes());
            boundary = params.getOrDefault(DS_PARAM_BOUNDARY, doc.getContent().toString().split(lineFeed)[0].substring(2));
        } else if (byte[].class.isAssignableFrom(doc.getContent().getClass())) {
            multipartData = new ByteArrayInputStream((byte[])doc.getContent());
            boundary = params.getOrDefault(DS_PARAM_BOUNDARY, new String((byte[])doc.getContent()).split(lineFeed)[0].substring(2));
        } else if (InputStream.class.isAssignableFrom(doc.getContent().getClass())) {
            InputStream is = (InputStream)doc.getContent();
            try {
                byte[] buf = new byte[is.available()];
                while (is.read(buf) != -1) {
                }
                multipartData = new ByteArrayInputStream(buf);
                boundary = params.getOrDefault(DS_PARAM_BOUNDARY, new String(buf).split(lineFeed)[0].substring(2));
            }
            catch (IOException e) {
                throw new PluginException("Unable to read multipart data", e);
            }
        }
        final String finalBoundary = boundary;
        final ByteArrayInputStream finalMultipartData = multipartData;
        try {
            List parts = new FileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(new RequestContext(){

                public String getCharacterEncoding() {
                    return "UTF-8";
                }

                public String getContentType() {
                    return "multipart/form-data; boundary=" + finalBoundary;
                }

                public int getContentLength() {
                    return finalMultipartData.available();
                }

                public InputStream getInputStream() throws IOException {
                    return finalMultipartData;
                }
            });
            for (FileItem part : parts) {
                ObjectNode partNode = mapper.createObjectNode();
                partNode.put("name", part.getFieldName());
                partNode.put("contentType", part.getContentType());
                String fileName = part.getName();
                if (fileName != null) {
                    partNode.put("fileName", fileName);
                    partNode.put("content", part.get());
                } else {
                    partNode.put("content", part.getString());
                }
                result.add(partNode);
            }
        }
        catch (FileUploadException e) {
            throw new PluginException("Unable to parse multipart data", e);
        }
        return this.ujsonFrom(result);
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        ByteArrayOutputStream baos;
        Map<String, String> params = mediaType.getParameters();
        String boundary = params.getOrDefault(DS_PARAM_BOUNDARY, "===" + System.currentTimeMillis() + "===");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(outputStream);
        Object javaInput = ujsonUtils.javaObjectFrom(input);
        if (!List.class.isAssignableFrom(javaInput.getClass())) {
            throw new PluginException("Invalid format; array of part objects is expected");
        }
        List parts = (List)javaInput;
        for (Map nextPart : parts) {
            if (!nextPart.containsKey("name")) {
                throw new PluginException("Invalid part format; part name is required");
            }
            if (!nextPart.containsKey("contentType")) {
                throw new PluginException("Invalid part format; part content type is required");
            }
            if (!nextPart.containsKey("content")) {
                throw new PluginException("Invalid part format; part content is required");
            }
            boolean isBinary = nextPart.containsKey("fileName");
            writer.append("--" + boundary).append(lineFeed);
            writer.append("Content-Disposition: form-data; name=\"" + nextPart.get("name") + "\"").append(isBinary ? "; filename=\"" + nextPart.get("fileName") + "\"" : "").append(lineFeed);
            writer.append("Content-Type: " + nextPart.get("contentType")).append(lineFeed);
            writer.append("Content-Transfer-Encoding: " + (isBinary ? "binary" : "8bit")).append(lineFeed).append(lineFeed);
            if (isBinary) {
                writer.flush();
                List fileBytes = (List)nextPart.get("content");
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                for (Double nextOne : fileBytes) {
                    content.write(nextOne.byteValue());
                }
                byte[] contentBytes = content.toByteArray();
                try {
                    outputStream.write(contentBytes);
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw new PluginException("Unable to write binary part", e);
                }
            } else {
                writer.append(nextPart.get("content").toString());
            }
            writer.append(lineFeed);
            writer.flush();
        }
        writer.append("--" + boundary + "--").append(lineFeed);
        writer.close();
        if (targetType.isAssignableFrom(ByteArrayOutputStream.class)) {
            return new DefaultDocument<ByteArrayOutputStream>(outputStream, mediaType);
        }
        if (targetType.isAssignableFrom(byte[].class)) {
            baos = new ByteArrayOutputStream();
            try {
                outputStream.writeTo(baos);
            }
            catch (IOException e) {
                throw new PluginException(e);
            }
            return new DefaultDocument<byte[]>(baos.toByteArray(), mediaType);
        }
        if (targetType.isAssignableFrom(String.class)) {
            baos = new ByteArrayOutputStream();
            try {
                outputStream.writeTo(baos);
            }
            catch (IOException e) {
                throw new PluginException(e);
            }
            return new DefaultDocument<String>(new String(baos.toByteArray()), mediaType);
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canWrite before invoking write"));
    }
}

