/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.language;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.language.AnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;

public class DefaultAnnotationExpressionFactory
implements AnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String languageName = languageAnnotation.language();
        Language language2 = camelContext.resolveLanguage(languageName);
        if (language2 == null) {
            throw new IllegalArgumentException("Cannot find the language: " + languageName + " on the classpath");
        }
        String expression = this.getExpressionFromAnnotation(annotation);
        if (expressionReturnType == Boolean.class || expressionReturnType == Boolean.TYPE) {
            Predicate predicate = language2.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        return language2.createExpression(expression);
    }

    protected String getExpressionFromAnnotation(Annotation annotation) {
        Object value = this.getAnnotationObjectValue(annotation, "value");
        if (value == null) {
            throw new IllegalArgumentException("Cannot determine the expression from the annotation: " + annotation);
        }
        return value.toString();
    }

    protected Object getAnnotationObjectValue(Annotation annotation, String methodName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(methodName, new Class[0]);
            return ObjectHelper.invokeMethod(method, annotation, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the Object value of the annotation: " + annotation + " as it does not have the method: " + methodName + "() method", e);
        }
    }
}

