/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.camel.util.ObjectHelper;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static void doWithClasses(Class<?> clazz, ClassCallback cc) throws IllegalArgumentException {
        Class<?>[] classes;
        for (Class<?> aClazz : classes = clazz.getDeclaredClasses()) {
            try {
                cc.doWith(aClazz);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access class '" + aClazz.getName() + "': " + String.valueOf(ex));
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field2 : fields = targetClass.getDeclaredFields()) {
                try {
                    fc.doWith(field2);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field2.getName() + "': " + String.valueOf(ex));
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + String.valueOf(ex));
            }
        }
        if (clazz.getSuperclass() != null) {
            ReflectionHelper.doWithMethods(clazz.getSuperclass(), mc);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionHelper.doWithMethods(genericDeclaration, mc);
            }
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        ObjectHelper.notNull(clazz, "Class must not be null");
        ObjectHelper.notNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static void setField(Field f, Object instance, Object value) {
        try {
            Class<?> type;
            if (!Modifier.isPublic(f.getModifiers()) && !f.canAccess(instance)) {
                f.setAccessible(true);
            }
            if (Boolean.TYPE == (type = f.getType())) {
                boolean val = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
                f.setBoolean(instance, val);
            } else if (Byte.TYPE == type) {
                byte val = value instanceof Byte ? (Byte)value : Byte.parseByte(value.toString());
                f.setByte(instance, val);
            } else if (Integer.TYPE == type) {
                int val = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                f.setInt(instance, val);
            } else if (Long.TYPE == type) {
                long val = value instanceof Long ? (Long)value : Long.parseLong(value.toString());
                f.setLong(instance, val);
            } else if (Float.TYPE == type) {
                float val = value instanceof Float ? ((Float)value).floatValue() : Float.parseFloat(value.toString());
                f.setFloat(instance, val);
            } else if (Double.TYPE == type) {
                double val = value instanceof Double ? (Double)value : Double.parseDouble(value.toString());
                f.setDouble(instance, val);
            } else {
                f.set(instance, value);
            }
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Cannot inject value of class: " + String.valueOf(value.getClass()) + " into: " + String.valueOf(f));
        }
    }

    public static Object getField(Field f, Object instance) {
        try {
            if (!Modifier.isPublic(f.getModifiers()) && !f.canAccess(instance)) {
                f.setAccessible(true);
            }
            return f.get(instance);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ClassCallback {
        public void doWith(Class<?> var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

