/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReifier
extends ProcessorReifier<LogDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(LogReifier.class);

    public LogReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (LogDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Logger logger;
        StringHelper.notEmpty(((LogDefinition)this.definition).getMessage(), "message", this);
        String msg = this.parseString(((LogDefinition)this.definition).getMessage());
        Expression exp = null;
        if (LanguageSupport.hasSimpleFunction(msg)) {
            exp = this.camelContext.resolveLanguage("simple").createExpression(msg);
        }
        if ((logger = ((LogDefinition)this.definition).getLoggerBean()) == null && ObjectHelper.isNotEmpty(((LogDefinition)this.definition).getLogger())) {
            logger = this.mandatoryLookup(((LogDefinition)this.definition).getLogger(), Logger.class);
        }
        if (logger == null) {
            logger = this.findSingleByType(Logger.class);
        }
        if (logger == null) {
            String name = this.parseString(((LogDefinition)this.definition).getLogName());
            if (name == null && (name = this.camelContext.getGlobalOption("CamelLogEipName")) != null) {
                LOG.debug("Using logName from CamelContext global option: {}", (Object)name);
            }
            if (name != null) {
                name = StringHelper.replaceFirst(name, "${class}", LogProcessor.class.getName());
                name = StringHelper.replaceFirst(name, "${contextId}", this.camelContext.getName());
                name = StringHelper.replaceFirst(name, "${routeId}", this.route.getRouteId());
                name = StringHelper.replaceFirst(name, "${groupId}", this.route.getGroup());
                name = StringHelper.replaceFirst(name, "${nodeId}", ((LogDefinition)this.definition).getId());
                name = StringHelper.replaceFirst(name, "${nodePrefixId}", ((LogDefinition)this.definition).getNodePrefixId());
                if (this.camelContext.isSourceLocationEnabled().booleanValue()) {
                    String source2 = LoggerHelper.getLineNumberLoggerName(this.definition);
                    name = StringHelper.replaceFirst(name, "${source}", source2);
                    name = StringHelper.replaceFirst(name, "${source.name}", StringHelper.before(source2, ":", source2));
                    name = StringHelper.replaceFirst(name, "${source.line}", StringHelper.after(source2, ":", ""));
                }
            }
            if (name == null) {
                if (this.camelContext.isSourceLocationEnabled().booleanValue() && (name = LoggerHelper.getLineNumberLoggerName(this.definition)) != null) {
                    LOG.debug("LogName is not configured, using source location as logName: {}", (Object)name);
                }
                if (name == null) {
                    name = this.route.getRouteId();
                    LOG.debug("LogName is not configured, using route id as logName: {}", (Object)name);
                }
            }
            logger = LoggerFactory.getLogger((String)name);
        }
        LoggingLevel level = ((LogDefinition)this.definition).getLoggingLevel() != null ? this.parse(LoggingLevel.class, ((LogDefinition)this.definition).getLoggingLevel()) : LoggingLevel.INFO;
        CamelLogger camelLogger = new CamelLogger(logger, level, ((LogDefinition)this.definition).getMarker());
        if (exp != null) {
            return new LogProcessor(exp, camelLogger, this.getMaskingFormatter(), this.camelContext.getCamelContextExtension().getLogListeners());
        }
        return new LogProcessor(msg, camelLogger, this.getMaskingFormatter(), this.camelContext.getCamelContextExtension().getLogListeners());
    }

    private MaskingFormatter getMaskingFormatter() {
        if (this.route.isLogMask().booleanValue()) {
            MaskingFormatter formatter = this.lookupByNameAndType("CamelCustomLogMask", MaskingFormatter.class);
            if (formatter == null) {
                formatter = new DefaultMaskingFormatter();
            }
            return formatter;
        }
        return null;
    }
}

