/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Direction {
    ASC("ASC"),
    DESC("DESC"),
    NASC("NASC"),
    NDESC("NDESC");

    private final String value;
    private static final Map<String, Direction> CONSTANTS;

    private Direction(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Direction fromValue(String value) {
        Direction constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Direction>();
        for (Direction c : Direction.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

