/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EndpointItem {
    EVENT("EVENT"),
    ENROLLMENT("ENROLLMENT"),
    TRACKED_ENTITY_INSTANCE("TRACKED_ENTITY_INSTANCE");

    private final String value;
    private static final Map<String, EndpointItem> CONSTANTS;

    private EndpointItem(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static EndpointItem fromValue(String value) {
        EndpointItem constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, EndpointItem>();
        for (EndpointItem c : EndpointItem.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

