/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_2_2.Property;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"jobParameters", "jobType", "name", "schedulingType"})
public class JobTypeInfo
implements Serializable {
    @JsonProperty(value="jobParameters")
    private List<Property> jobParameters;
    @JsonProperty(value="jobType")
    private JobTypeRef jobType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="schedulingType")
    private SchedulingTypeRef schedulingType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 2084261574103558191L;

    public JobTypeInfo() {
    }

    public JobTypeInfo(JobTypeInfo source2) {
        this.jobParameters = source2.jobParameters;
        this.jobType = source2.jobType;
        this.name = source2.name;
        this.schedulingType = source2.schedulingType;
    }

    public JobTypeInfo(List<Property> jobParameters, JobTypeRef jobType, String name, SchedulingTypeRef schedulingType) {
        this.jobParameters = jobParameters;
        this.jobType = jobType;
        this.name = name;
        this.schedulingType = schedulingType;
    }

    @JsonProperty(value="jobParameters")
    public Optional<List<Property>> getJobParameters() {
        return Optional.ofNullable(this.jobParameters);
    }

    @JsonProperty(value="jobParameters")
    public void setJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public JobTypeInfo withJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
        return this;
    }

    @JsonProperty(value="jobType")
    public JobTypeRef getJobType() {
        return this.jobType;
    }

    @JsonProperty(value="jobType")
    public void setJobType(JobTypeRef jobType) {
        this.jobType = jobType;
    }

    public JobTypeInfo withJobType(JobTypeRef jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public JobTypeInfo withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="schedulingType")
    public SchedulingTypeRef getSchedulingType() {
        return this.schedulingType;
    }

    @JsonProperty(value="schedulingType")
    public void setSchedulingType(SchedulingTypeRef schedulingType) {
        this.schedulingType = schedulingType;
    }

    public JobTypeInfo withSchedulingType(SchedulingTypeRef schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public JobTypeInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("jobParameters".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"jobParameters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Property>\", but got " + value.getClass().toString());
            }
            this.setJobParameters((List)value);
            return true;
        }
        if ("jobType".equals(name)) {
            if (!(value instanceof JobTypeRef)) {
                throw new IllegalArgumentException("property \"jobType\" is of type \"org.hisp.dhis.api.model.v40_2_2.JobTypeInfo.JobTypeRef\", but got " + value.getClass().toString());
            }
            this.setJobType((JobTypeRef)((Object)value));
            return true;
        }
        if ("name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setName((String)value);
            return true;
        }
        if ("schedulingType".equals(name)) {
            if (!(value instanceof SchedulingTypeRef)) {
                throw new IllegalArgumentException("property \"schedulingType\" is of type \"org.hisp.dhis.api.model.v40_2_2.JobTypeInfo.SchedulingTypeRef\", but got " + value.getClass().toString());
            }
            this.setSchedulingType((SchedulingTypeRef)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("jobParameters".equals(name)) {
            return this.getJobParameters();
        }
        if ("jobType".equals(name)) {
            return this.getJobType();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("schedulingType".equals(name)) {
            return this.getSchedulingType();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public JobTypeInfo with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JobTypeInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jobParameters");
        sb.append('=');
        sb.append(this.jobParameters == null ? "<null>" : this.jobParameters);
        sb.append(',');
        sb.append("jobType");
        sb.append('=');
        sb.append(this.jobType == null ? "<null>" : this.jobType);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("schedulingType");
        sb.append('=');
        sb.append(this.schedulingType == null ? "<null>" : this.schedulingType);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.schedulingType == null ? 0 : this.schedulingType.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.jobParameters == null ? 0 : this.jobParameters.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.jobType == null ? 0 : this.jobType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JobTypeInfo)) {
            return false;
        }
        JobTypeInfo rhs = (JobTypeInfo)other;
        return (this.schedulingType == rhs.schedulingType || this.schedulingType != null && this.schedulingType.equals((Object)rhs.schedulingType)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.jobParameters == rhs.jobParameters || this.jobParameters != null && this.jobParameters.equals(rhs.jobParameters)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.jobType == rhs.jobType || this.jobType != null && this.jobType.equals((Object)rhs.jobType));
    }

    public static enum SchedulingTypeRef {
        CRON("CRON"),
        FIXED_DELAY("FIXED_DELAY");

        private final String value;
        private static final Map<String, SchedulingTypeRef> CONSTANTS;

        private SchedulingTypeRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SchedulingTypeRef fromValue(String value) {
            SchedulingTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SchedulingTypeRef>();
            for (SchedulingTypeRef c : SchedulingTypeRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum JobTypeRef {
        DATA_STATISTICS("DATA_STATISTICS"),
        DATA_INTEGRITY("DATA_INTEGRITY"),
        RESOURCE_TABLE("RESOURCE_TABLE"),
        ANALYTICS_TABLE("ANALYTICS_TABLE"),
        CONTINUOUS_ANALYTICS_TABLE("CONTINUOUS_ANALYTICS_TABLE"),
        DATA_SYNC("DATA_SYNC"),
        TRACKER_PROGRAMS_DATA_SYNC("TRACKER_PROGRAMS_DATA_SYNC"),
        EVENT_PROGRAMS_DATA_SYNC("EVENT_PROGRAMS_DATA_SYNC"),
        FILE_RESOURCE_CLEANUP("FILE_RESOURCE_CLEANUP"),
        IMAGE_PROCESSING("IMAGE_PROCESSING"),
        META_DATA_SYNC("META_DATA_SYNC"),
        AGGREGATE_DATA_EXCHANGE("AGGREGATE_DATA_EXCHANGE"),
        SMS_SEND("SMS_SEND"),
        SEND_SCHEDULED_MESSAGE("SEND_SCHEDULED_MESSAGE"),
        PROGRAM_NOTIFICATIONS("PROGRAM_NOTIFICATIONS"),
        VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
        CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
        MONITORING("MONITORING"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        TRACKER_SEARCH_OPTIMIZATION("TRACKER_SEARCH_OPTIMIZATION"),
        PREDICTOR("PREDICTOR"),
        DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
        REMOVE_USED_OR_EXPIRED_RESERVED_VALUES("REMOVE_USED_OR_EXPIRED_RESERVED_VALUES"),
        TRACKER_IMPORT_JOB("TRACKER_IMPORT_JOB"),
        TRACKER_IMPORT_NOTIFICATION_JOB("TRACKER_IMPORT_NOTIFICATION_JOB"),
        TRACKER_IMPORT_RULE_ENGINE_JOB("TRACKER_IMPORT_RULE_ENGINE_JOB"),
        MATERIALIZED_SQL_VIEW_UPDATE("MATERIALIZED_SQL_VIEW_UPDATE"),
        LEADER_ELECTION("LEADER_ELECTION"),
        LEADER_RENEWAL("LEADER_RENEWAL"),
        COMPLETE_DATA_SET_REGISTRATION_IMPORT("COMPLETE_DATA_SET_REGISTRATION_IMPORT"),
        DATAVALUE_IMPORT_INTERNAL("DATAVALUE_IMPORT_INTERNAL"),
        METADATA_IMPORT("METADATA_IMPORT"),
        DATAVALUE_IMPORT("DATAVALUE_IMPORT"),
        GEOJSON_IMPORT("GEOJSON_IMPORT"),
        EVENT_IMPORT("EVENT_IMPORT"),
        ENROLLMENT_IMPORT("ENROLLMENT_IMPORT"),
        TEI_IMPORT("TEI_IMPORT"),
        DISABLE_INACTIVE_USERS("DISABLE_INACTIVE_USERS"),
        ACCOUNT_EXPIRY_ALERT("ACCOUNT_EXPIRY_ALERT"),
        SYSTEM_VERSION_UPDATE_CHECK("SYSTEM_VERSION_UPDATE_CHECK"),
        TEST("TEST"),
        MOCK("MOCK"),
        GML_IMPORT("GML_IMPORT"),
        ANALYTICSTABLE_UPDATE("ANALYTICSTABLE_UPDATE"),
        PROGRAM_DATA_SYNC("PROGRAM_DATA_SYNC");

        private final String value;
        private static final Map<String, JobTypeRef> CONSTANTS;

        private JobTypeRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobTypeRef fromValue(String value) {
            JobTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, JobTypeRef>();
            for (JobTypeRef c : JobTypeRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

