/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk;

import java.util.concurrent.TimeUnit;
import org.hisp.dhis.integration.sdk.DefaultDhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.security.SecurityContext;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonConverterFactory;
import org.hisp.dhis.integration.sdk.internal.security.BasicCredentialsSecurityContext;
import org.hisp.dhis.integration.sdk.internal.security.PersonalAccessTokenSecurityContext;

public class Dhis2ClientBuilder {
    private final SecurityContext securityContext;
    private final String baseApiUrl;
    private int maxIdleConnections = 5;
    private long keepAliveDurationMs = 300000L;
    private long callTimeoutMs = 0L;
    private long readTimeoutMs = 10000L;
    private long writeTimeoutMs = 10000L;
    private long connectTimeoutMs = 10000L;
    private ConverterFactory converterFactory = new JacksonConverterFactory();

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String username, String password) {
        return new Dhis2ClientBuilder(baseApiUrl, new BasicCredentialsSecurityContext(username, password));
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String personalAccessToken) {
        return new Dhis2ClientBuilder(baseApiUrl, new PersonalAccessTokenSecurityContext(personalAccessToken));
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, SecurityContext securityContext) {
        return new Dhis2ClientBuilder(baseApiUrl, securityContext);
    }

    private Dhis2ClientBuilder(String baseApiUrl, SecurityContext securityContext) {
        this.baseApiUrl = baseApiUrl.trim();
        this.securityContext = securityContext;
    }

    public Dhis2ClientBuilder withMaxIdleConnections(int maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
        return this;
    }

    public Dhis2ClientBuilder withKeepAliveDuration(long keepAliveDuration, TimeUnit timeUnit) {
        this.keepAliveDurationMs = timeUnit.toMillis(keepAliveDuration);
        return this;
    }

    public Dhis2ClientBuilder withCallTimeout(long callTimeout, TimeUnit timeUnit) {
        this.callTimeoutMs = timeUnit.toMillis(callTimeout);
        return this;
    }

    public Dhis2ClientBuilder withReadTimeout(long readTimeout, TimeUnit timeUnit) {
        this.readTimeoutMs = timeUnit.toMillis(readTimeout);
        return this;
    }

    public Dhis2ClientBuilder withWriteTimeout(long writeTimeout, TimeUnit timeUnit) {
        this.writeTimeoutMs = timeUnit.toMillis(writeTimeout);
        return this;
    }

    public Dhis2ClientBuilder withConnectTimeout(long connectTimeout, TimeUnit timeUnit) {
        this.connectTimeoutMs = timeUnit.toMillis(connectTimeout);
        return this;
    }

    public Dhis2ClientBuilder withConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
        return this;
    }

    public Dhis2Client build() {
        StringBuilder apiPathStringBuilder = new StringBuilder();
        apiPathStringBuilder.append(this.baseApiUrl);
        if (!this.baseApiUrl.endsWith("/")) {
            apiPathStringBuilder.append("/");
        }
        return new DefaultDhis2Client(apiPathStringBuilder.toString(), this.securityContext, this.converterFactory, this.maxIdleConnections, this.keepAliveDurationMs, this.callTimeoutMs, this.readTimeoutMs, this.writeTimeoutMs, this.connectTimeoutMs);
    }
}

