/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.support.period.type;

import java.util.Calendar;
import java.util.Date;
import org.hisp.dhis.integration.sdk.support.period.type.AbstractPeriod;

public class WeeklyPeriod
extends AbstractPeriod {
    private final int weekStartDay;
    private final String suffix;

    public WeeklyPeriod(Calendar calendar, int weekStartDay, String suffix) {
        super(calendar, "yyyy");
        this.weekStartDay = weekStartDay;
        this.suffix = suffix;
    }

    @Override
    protected void moveToStartOfCurrentPeriod() {
        this.calendar.getTime();
        this.calendar.setFirstDayOfWeek(this.weekStartDay);
        this.calendar.setMinimalDaysInFirstWeek(4);
        this.setDayOfWeek(this.calendar, this.weekStartDay);
    }

    @Override
    protected void moveToStartOfCurrentYear() {
        this.moveToStartOfCurrentPeriod();
        this.calendar.set(3, 1);
    }

    @Override
    protected void movePeriods(int number) {
        this.calendar.add(3, number);
    }

    @Override
    protected String formatTime() {
        Calendar cal = (Calendar)this.calendar.clone();
        this.setDayOfWeek(cal, this.weekStartDay + 3);
        Date fourthWeekDay = cal.getTime();
        String year = this.idFormatter.format(fourthWeekDay);
        Integer weekOfYear = cal.get(3);
        return year + this.suffix + weekOfYear;
    }
}

