/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AggregationStrategyClause;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.PredicateClause;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends OutputDefinition<AggregateDefinition>
implements ExecutorServiceAwareDefinition<AggregateDefinition>,
AggregationStrategyAwareDefinition<AggregateDefinition> {
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlTransient
    private AggregationRepository aggregationRepositoryBean;
    @XmlTransient
    private AggregateController aggregateControllerBean;
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlTransient
    private ScheduledExecutorService timeoutCheckerExecutorServiceBean;
    @XmlTransient
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy;
    @XmlElement(name="correlationExpression", required=true)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlElement(name="completionPredicate")
    @AsPredicate
    @Metadata(label="advanced")
    private ExpressionSubElementDefinition completionPredicate;
    @XmlElement(name="completionTimeoutExpression")
    @Metadata(label="advanced")
    private ExpressionSubElementDefinition completionTimeoutExpression;
    @XmlElement(name="completionSizeExpression")
    @Metadata(label="advanced")
    private ExpressionSubElementDefinition completionSizeExpression;
    @XmlElement(name="optimisticLockRetryPolicy")
    @Metadata(label="advanced")
    private OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String optimisticLocking;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ScheduledExecutorService")
    private String timeoutCheckerExecutorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.processor.aggregate.AggregateController")
    private String aggregateController;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.spi.AggregationRepository")
    private String aggregationRepository;
    @XmlAttribute(required=true)
    @Metadata(javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String aggregationStrategyMethodAllowNull;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String completionSize;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String completionInterval;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String completionTimeout;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="1000", javaType="java.time.Duration")
    private String completionTimeoutCheckerInterval;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String completionFromBatchConsumer;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String completionOnNewCorrelationGroup;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String eagerCheckCompletion;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreInvalidCorrelationKeys;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer")
    private String closeCorrelationKeyOnCompletion;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String discardOnCompletionTimeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String discardOnAggregationFailure;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String forceCompletionOnStop;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String completeAllOnStop;

    public AggregateDefinition() {
    }

    protected AggregateDefinition(AggregateDefinition source2) {
        super(source2);
        this.expression = source2.expression != null ? source2.expression.copyDefinition() : null;
        this.aggregationStrategyBean = source2.aggregationStrategyBean;
        this.aggregationRepositoryBean = source2.aggregationRepositoryBean;
        this.aggregateControllerBean = source2.aggregateControllerBean;
        this.executorServiceBean = source2.executorServiceBean;
        this.timeoutCheckerExecutorServiceBean = source2.timeoutCheckerExecutorServiceBean;
        this.optimisticLockRetryPolicy = source2.optimisticLockRetryPolicy;
        this.correlationExpression = source2.correlationExpression != null ? source2.correlationExpression.copyDefinition() : null;
        this.completionPredicate = source2.completionPredicate != null ? source2.completionPredicate.copyDefinition() : null;
        this.completionTimeoutExpression = source2.completionTimeoutExpression != null ? source2.completionTimeoutExpression.copyDefinition() : null;
        this.completionSizeExpression = source2.completionSizeExpression != null ? source2.completionSizeExpression.copyDefinition() : null;
        this.optimisticLockRetryPolicyDefinition = source2.optimisticLockRetryPolicyDefinition != null ? source2.optimisticLockRetryPolicyDefinition.copyDefinition() : null;
        this.parallelProcessing = source2.parallelProcessing;
        this.optimisticLocking = source2.optimisticLocking;
        this.executorService = source2.executorService;
        this.timeoutCheckerExecutorService = source2.timeoutCheckerExecutorService;
        this.aggregateController = source2.aggregateController;
        this.aggregationRepository = source2.aggregationRepository;
        this.aggregationStrategy = source2.aggregationStrategy;
        this.aggregationStrategyMethodName = source2.aggregationStrategyMethodName;
        this.aggregationStrategyMethodAllowNull = source2.aggregationStrategyMethodAllowNull;
        this.completionSize = source2.completionSize;
        this.completionInterval = source2.completionInterval;
        this.completionTimeout = source2.completionTimeout;
        this.completionTimeoutCheckerInterval = source2.completionTimeoutCheckerInterval;
        this.completionFromBatchConsumer = source2.completionFromBatchConsumer;
        this.completionOnNewCorrelationGroup = source2.completionOnNewCorrelationGroup;
        this.eagerCheckCompletion = source2.eagerCheckCompletion;
        this.ignoreInvalidCorrelationKeys = source2.ignoreInvalidCorrelationKeys;
        this.closeCorrelationKeyOnCompletion = source2.closeCorrelationKeyOnCompletion;
        this.discardOnCompletionTimeout = source2.discardOnCompletionTimeout;
        this.discardOnAggregationFailure = source2.discardOnAggregationFailure;
        this.forceCompletionOnStop = source2.forceCompletionOnStop;
        this.completeAllOnStop = source2.completeAllOnStop;
    }

    public AggregateDefinition(@AsPredicate Predicate predicate) {
        this(ExpressionNodeHelper.toExpressionDefinition(predicate));
    }

    public AggregateDefinition(Expression expression) {
        this(ExpressionNodeHelper.toExpressionDefinition(expression));
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.setExpression(correlationExpression);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(correlationExpression);
        this.setCorrelationExpression(cor);
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategyBean = aggregationStrategy;
    }

    @Override
    public AggregateDefinition copyDefinition() {
        return new AggregateDefinition(this);
    }

    @Override
    public String toString() {
        return "Aggregate[" + this.description() + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    protected String description() {
        return this.getExpression() != null ? this.getExpression().getLabel() : "";
    }

    @Override
    public String getShortName() {
        return "aggregate";
    }

    @Override
    public String getLabel() {
        return "aggregate[" + this.description() + "]";
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        ExpressionFactory model;
        ExpressionClause clause;
        Expression exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)exp).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)model;
            this.correlationExpression = new ExpressionSubElementDefinition();
            this.correlationExpression.setExpressionType(expressionDefinition);
        }
    }

    @Override
    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    public AggregationRepository getAggregationRepositoryBean() {
        return this.aggregationRepositoryBean;
    }

    @Override
    public String getAggregationStrategyRef() {
        return this.aggregationStrategy;
    }

    public AggregateController getAggregateControllerBean() {
        return this.aggregateControllerBean;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorServiceBean() {
        return this.timeoutCheckerExecutorServiceBean;
    }

    public String getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepositoryBean = aggregationRepository;
    }

    public void setAggregationRepository(String aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    @Override
    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String strategyMethodName) {
        this.aggregationStrategyMethodName = strategyMethodName;
    }

    @Override
    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public String getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(String completionSize) {
        this.completionSize = completionSize;
    }

    public OptimisticLockRetryPolicyDefinition getOptimisticLockRetryPolicyDefinition() {
        return this.optimisticLockRetryPolicyDefinition;
    }

    public void setOptimisticLockRetryPolicyDefinition(OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition) {
        this.optimisticLockRetryPolicyDefinition = optimisticLockRetryPolicyDefinition;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public String getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(String completionInterval) {
        this.completionInterval = completionInterval;
    }

    public String getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(String completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public String getCompletionTimeoutCheckerInterval() {
        return this.completionTimeoutCheckerInterval;
    }

    public void setCompletionTimeoutCheckerInterval(String completionTimeoutCheckerInterval) {
        this.completionTimeoutCheckerInterval = completionTimeoutCheckerInterval;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(ExpressionSubElementDefinition completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public ExpressionSubElementDefinition getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(ExpressionSubElementDefinition completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public String getCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(String completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public String getCompletionOnNewCorrelationGroup() {
        return this.completionOnNewCorrelationGroup;
    }

    public void setCompletionOnNewCorrelationGroup(String completionOnNewCorrelationGroup) {
        this.completionOnNewCorrelationGroup = completionOnNewCorrelationGroup;
    }

    public String getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(String optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }

    public String getEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(String eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public String getIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(String ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public String getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(String closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public String getDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(String discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public String getDiscardOnAggregationFailure() {
        return this.discardOnAggregationFailure;
    }

    public void setDiscardOnAggregationFailure(String discardOnAggregationFailure) {
        this.discardOnAggregationFailure = discardOnAggregationFailure;
    }

    public String getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public void setTimeoutCheckerExecutorService(String timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public String getForceCompletionOnStop() {
        return this.forceCompletionOnStop;
    }

    public void setForceCompletionOnStop(String forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public String getCompleteAllOnStop() {
        return this.completeAllOnStop;
    }

    public void setCompleteAllOnStop(String completeAllOnStop) {
        this.completeAllOnStop = completeAllOnStop;
    }

    public String getAggregateController() {
        return this.aggregateController;
    }

    public void setAggregateController(String aggregateController) {
        this.aggregateController = aggregateController;
    }

    public void setAggregateController(AggregateController aggregateController) {
        this.aggregateControllerBean = aggregateController;
    }

    public AggregateDefinition eagerCheckCompletion() {
        this.setEagerCheckCompletion(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition ignoreInvalidCorrelationKeys() {
        this.setIgnoreInvalidCorrelationKeys(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition closeCorrelationKeyOnCompletion(int capacity) {
        this.setCloseCorrelationKeyOnCompletion(Integer.toString(capacity));
        return this;
    }

    public AggregateDefinition discardOnCompletionTimeout() {
        this.setDiscardOnCompletionTimeout(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition discardOnAggregationFailure() {
        this.setDiscardOnAggregationFailure(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionFromBatchConsumer() {
        this.setCompletionFromBatchConsumer(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionOnNewCorrelationGroup() {
        this.setCompletionOnNewCorrelationGroup(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completionSize(String completionSize) {
        this.setCompletionSize(completionSize);
        return this;
    }

    public AggregateDefinition completionSize(int completionSize) {
        this.setCompletionSize(Integer.toString(completionSize));
        return this;
    }

    public AggregateDefinition completionSize(Expression completionSize) {
        this.setCompletionSizeExpression(new ExpressionSubElementDefinition(completionSize));
        return this;
    }

    public AggregateDefinition completionInterval(long completionInterval) {
        this.setCompletionInterval(Long.toString(completionInterval));
        return this;
    }

    public AggregateDefinition completionInterval(String completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public AggregateDefinition completionTimeout(String completionTimeout) {
        this.setCompletionTimeout(completionTimeout);
        return this;
    }

    public AggregateDefinition completionTimeout(long completionTimeout) {
        this.setCompletionTimeout(Long.toString(completionTimeout));
        return this;
    }

    public AggregateDefinition completionTimeout(Expression completionTimeout) {
        this.setCompletionTimeoutExpression(new ExpressionSubElementDefinition(completionTimeout));
        return this;
    }

    public AggregateDefinition completionTimeoutCheckerInterval(long completionTimeoutCheckerInterval) {
        this.setCompletionTimeoutCheckerInterval(Long.toString(completionTimeoutCheckerInterval));
        return this;
    }

    public AggregationStrategyClause<AggregateDefinition> aggregationStrategy() {
        AggregationStrategyClause<AggregateDefinition> clause;
        this.aggregationStrategyBean = clause = new AggregationStrategyClause<AggregateDefinition>(this);
        return clause;
    }

    @Override
    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
        return this;
    }

    @Override
    public AggregateDefinition aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodAllowNull() {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition aggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepositoryBean = aggregationRepository;
        return this;
    }

    public AggregateDefinition aggregationRepository(String aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
        return this;
    }

    public AggregateDefinition completionPredicate(@AsPredicate Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completionPredicate() {
        PredicateClause<AggregateDefinition> clause = new PredicateClause<AggregateDefinition>(this);
        this.completionPredicate(clause);
        return clause;
    }

    @AsPredicate
    public PredicateClause<AggregateDefinition> completion() {
        return this.completionPredicate();
    }

    public AggregateDefinition completion(@AsPredicate Predicate predicate) {
        return this.completionPredicate(predicate);
    }

    public AggregateDefinition forceCompletionOnStop() {
        this.setForceCompletionOnStop(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition completeAllOnStop() {
        this.setCompleteAllOnStop(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition parallelProcessing() {
        this.setParallelProcessing(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(Boolean.toString(parallelProcessing));
        return this;
    }

    public AggregateDefinition optimisticLocking() {
        this.setOptimisticLocking(Boolean.toString(true));
        return this;
    }

    public AggregateDefinition optimisticLockRetryPolicy(OptimisticLockRetryPolicy policy) {
        this.setOptimisticLockRetryPolicy(policy);
        return this;
    }

    @Override
    public AggregateDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public AggregateDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(ScheduledExecutorService executorService) {
        this.timeoutCheckerExecutorServiceBean = executorService;
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(String executorServiceRef) {
        this.setTimeoutCheckerExecutorService(executorServiceRef);
        return this;
    }

    public AggregateDefinition aggregateController(AggregateController aggregateController) {
        this.aggregateControllerBean = aggregateController;
        return this;
    }

    public AggregateDefinition aggregateController(String aggregateController) {
        this.setAggregateController(aggregateController);
        return this;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + String.valueOf(this));
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }
}

