/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends ExpressionNode
implements AggregationStrategyAwareDefinition<PollEnrichDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlAttribute
    private String variableReceive;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodAllowNull;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String aggregateOnException;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration", defaultValue="-1")
    private String timeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer")
    private String cacheSize;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreInvalidEndpoint;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String autoStartComponents;

    public PollEnrichDefinition() {
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, long timeout2) {
        this.aggregationStrategyBean = aggregationStrategy;
        this.timeout = Long.toString(timeout2);
    }

    protected PollEnrichDefinition(PollEnrichDefinition source2) {
        super(source2);
        this.aggregationStrategyBean = source2.aggregationStrategyBean;
        this.variableReceive = source2.variableReceive;
        this.aggregationStrategy = source2.aggregationStrategy;
        this.aggregationStrategyMethodName = source2.aggregationStrategyMethodName;
        this.aggregationStrategyMethodAllowNull = source2.aggregationStrategyMethodAllowNull;
        this.aggregateOnException = source2.aggregateOnException;
        this.timeout = source2.timeout;
        this.cacheSize = source2.cacheSize;
        this.ignoreInvalidEndpoint = source2.ignoreInvalidEndpoint;
        this.autoStartComponents = source2.autoStartComponents;
    }

    public String toString() {
        return "PollEnrich[" + String.valueOf(this.getExpression()) + "]";
    }

    @Override
    public String getShortName() {
        return "pollEnrich";
    }

    @Override
    public String getLabel() {
        return "pollEnrich[" + String.valueOf(this.getExpression()) + "]";
    }

    public PollEnrichDefinition timeout(long timeout2) {
        this.setTimeout(Long.toString(timeout2));
        return this;
    }

    public PollEnrichDefinition timeout(String timeout2) {
        this.setTimeout(timeout2);
        return this;
    }

    public PollEnrichDefinition variableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
        return this;
    }

    @Override
    public PollEnrichDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
        return this;
    }

    @Override
    public PollEnrichDefinition aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(aggregationStrategyMethodAllowNull));
        return this;
    }

    public PollEnrichDefinition aggregateOnException(boolean aggregateOnException) {
        this.setAggregateOnException(Boolean.toString(aggregateOnException));
        return this;
    }

    public PollEnrichDefinition cacheSize(int cacheSize) {
        this.setCacheSize(Integer.toString(cacheSize));
        return this;
    }

    public PollEnrichDefinition cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public PollEnrichDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(Boolean.toString(true));
        return this;
    }

    public PollEnrichDefinition autoStartComponents(String autoStartComponents) {
        this.setAutoStartComponents(autoStartComponents);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    @Override
    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    @Override
    public String getAggregationStrategyRef() {
        return this.aggregationStrategy;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
    }

    @Override
    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    @Override
    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public String getAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(String aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(String ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public String getAutoStartComponents() {
        return this.autoStartComponents;
    }

    public void setAutoStartComponents(String autoStartComponents) {
        this.autoStartComponents = autoStartComponents;
    }

    @Override
    public PollEnrichDefinition copyDefinition() {
        return new PollEnrichDefinition(this);
    }
}

