/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="weightedLoadBalancer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlAttribute(required=true)
    private String distributionRatio;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue=",")
    private String distributionRatioDelimiter;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String roundRobin;

    public WeightedLoadBalancerDefinition() {
    }

    protected WeightedLoadBalancerDefinition(WeightedLoadBalancerDefinition source2) {
        super(source2);
        this.distributionRatio = source2.distributionRatio;
        this.distributionRatioDelimiter = source2.distributionRatioDelimiter;
        this.roundRobin = source2.roundRobin;
    }

    @Override
    public WeightedLoadBalancerDefinition copyDefinition() {
        return new WeightedLoadBalancerDefinition(this);
    }

    public String getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(String roundRobin) {
        this.roundRobin = roundRobin;
    }

    public String getDistributionRatio() {
        return this.distributionRatio;
    }

    public void setDistributionRatio(String distributionRatio) {
        this.distributionRatio = distributionRatio;
    }

    public String getDistributionRatioDelimiter() {
        return this.distributionRatioDelimiter == null ? "," : this.distributionRatioDelimiter;
    }

    public void setDistributionRatioDelimiter(String distributionRatioDelimiter) {
        this.distributionRatioDelimiter = distributionRatioDelimiter;
    }

    @Override
    public String toString() {
        if (this.roundRobin == null || Boolean.FALSE.toString().equals(this.roundRobin)) {
            return "WeightedRandomLoadBalancer[" + this.distributionRatio + "]";
        }
        if (Boolean.TRUE.toString().equals(this.roundRobin)) {
            return "WeightedRoundRobinLoadBalancer[" + this.distributionRatio + "]";
        }
        return "WeightedLoadBalancer[roundRobin=" + this.roundRobin + "," + this.distributionRatio + "]";
    }
}

