/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RenderFormat {
    JSON("JSON"),
    XML("XML"),
    ADX_XML("ADX_XML"),
    CSV("CSV");

    private final String value;
    private static final Map<String, RenderFormat> CONSTANTS;

    private RenderFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static RenderFormat fromValue(String value) {
        RenderFormat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RenderFormat>();
        for (RenderFormat c : RenderFormat.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

