/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"method", "parameter"})
public class TextPatternSegment
implements Serializable {
    @JsonProperty(value="method")
    private TextPatternMethod method;
    @JsonProperty(value="parameter")
    private String parameter;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -8416195528434472794L;

    public TextPatternSegment() {
    }

    public TextPatternSegment(TextPatternSegment source2) {
        this.method = source2.method;
        this.parameter = source2.parameter;
    }

    public TextPatternSegment(TextPatternMethod method, String parameter) {
        this.method = method;
        this.parameter = parameter;
    }

    @JsonProperty(value="method")
    public Optional<TextPatternMethod> getMethod() {
        return Optional.ofNullable(this.method);
    }

    @JsonProperty(value="method")
    public void setMethod(TextPatternMethod method) {
        this.method = method;
    }

    public TextPatternSegment withMethod(TextPatternMethod method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="parameter")
    public Optional<String> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    @JsonProperty(value="parameter")
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public TextPatternSegment withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TextPatternSegment withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("method".equals(name)) {
            if (!(value instanceof TextPatternMethod)) {
                throw new IllegalArgumentException("property \"method\" is of type \"org.hisp.dhis.api.model.v2_39_1.TextPatternSegment.TextPatternMethod\", but got " + value.getClass().toString());
            }
            this.setMethod((TextPatternMethod)((Object)value));
            return true;
        }
        if ("parameter".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"parameter\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setParameter((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("method".equals(name)) {
            return this.getMethod();
        }
        if ("parameter".equals(name)) {
            return this.getParameter();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public TextPatternSegment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextPatternSegment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("method");
        sb.append('=');
        sb.append(this.method == null ? "<null>" : this.method);
        sb.append(',');
        sb.append("parameter");
        sb.append('=');
        sb.append(this.parameter == null ? "<null>" : this.parameter);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.method == null ? 0 : this.method.hashCode());
        result = result * 31 + (this.parameter == null ? 0 : this.parameter.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TextPatternSegment)) {
            return false;
        }
        TextPatternSegment rhs = (TextPatternSegment)other;
        return (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.method == rhs.method || this.method != null && this.method.equals((Object)rhs.method)) && (this.parameter == rhs.parameter || this.parameter != null && this.parameter.equals(rhs.parameter));
    }

    public static enum TextPatternMethod {
        TEXT("TEXT"),
        RANDOM("RANDOM"),
        SEQUENTIAL("SEQUENTIAL"),
        ORG_UNIT_CODE("ORG_UNIT_CODE"),
        CURRENT_DATE("CURRENT_DATE");

        private final String value;
        private static final Map<String, TextPatternMethod> CONSTANTS;

        private TextPatternMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TextPatternMethod fromValue(String value) {
            TextPatternMethod constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TextPatternMethod>();
            for (TextPatternMethod c : TextPatternMethod.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

