/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal;

import java.io.InputStream;
import okhttp3.Response;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;

public class DefaultDhis2Response
implements Dhis2Response {
    protected final Response response;
    protected final ConverterFactory converterFactory;

    public DefaultDhis2Response(Response response, ConverterFactory converterFactory) {
        this.response = response;
        this.converterFactory = converterFactory;
    }

    @Override
    public <T> T returnAs(Class<T> responseType) {
        return this.converterFactory.createResponseConverter(responseType).convert(this.response.body());
    }

    @Override
    public InputStream read() {
        return this.response.body().byteStream();
    }

    @Override
    public String getUrl() {
        return this.response.request().url().toString();
    }

    public Response getResponse() {
        return this.response;
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

