/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.converter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.hisp.dhis.integration.sdk.api.Dhis2ClientException;
import org.hisp.dhis.integration.sdk.api.converter.ResponseConverter;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonConverter;

public class JacksonResponseConverter<T>
implements ResponseConverter<T> {
    private final Class<T> returnType;
    private final JacksonConverter jacksonConverter;

    public JacksonResponseConverter(Class<T> returnType, JacksonConverter jacksonConverter) {
        this.returnType = returnType;
        this.jacksonConverter = jacksonConverter;
    }

    @Override
    public T convert(ResponseBody responseBody) {
        try {
            if (this.returnType.equals(String.class)) {
                String string = responseBody.string();
                return (T)string;
            }
            T t = this.jacksonConverter.convert(responseBody.charStream(), this.returnType);
            return t;
        }
        catch (IOException e) {
            throw new Dhis2ClientException(e);
        }
        finally {
            responseBody.close();
        }
    }

    @Override
    public T convert(List<Map<String, Object>> responseBody) {
        return (T)this.jacksonConverter.convert(responseBody, List.class, this.returnType);
    }
}

