/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.support.period.type;

import java.util.Calendar;
import org.hisp.dhis.integration.sdk.support.period.type.AbstractPeriod;

public class SixMonthlyPeriod
extends AbstractPeriod {
    protected int durationInMonths = 6;
    protected String idAdditionalString = "S";
    protected int startMonth = 0;

    public SixMonthlyPeriod(Calendar calendar) {
        super(calendar, "yyyy");
    }

    @Override
    protected void moveToStartOfCurrentPeriod() {
        this.calendar.set(5, 1);
        int currentMonth = this.calendar.get(2);
        int monthsFromStart = (currentMonth - this.startMonth + 12) % this.durationInMonths;
        int currentPeriodStartMonth = (currentMonth - monthsFromStart + 12) % 12;
        if (currentMonth - monthsFromStart < 0) {
            this.calendar.add(1, -1);
        }
        this.calendar.set(2, currentPeriodStartMonth);
    }

    @Override
    protected void moveToStartOfCurrentYear() {
        this.calendar.set(5, 1);
        if (this.startMonth >= 6) {
            this.calendar.add(1, -1);
        }
        this.calendar.set(2, this.startMonth);
    }

    @Override
    protected void movePeriods(int number) {
        this.calendar.add(2, this.durationInMonths * number);
    }

    @Override
    protected String formatTime() {
        Calendar calendarCopy = (Calendar)this.calendar.clone();
        if (calendarCopy.get(2) < this.startMonth) {
            calendarCopy.add(1, -1);
        }
        int periodNumber = (calendarCopy.get(2) - this.startMonth + 12) % 12 / this.durationInMonths + 1;
        String year = this.idFormatter.format(calendarCopy.getTime());
        return year + this.idAdditionalString + periodNumber;
    }
}

