/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean;

import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import org.apache.camel.component.digitalocean.constants.DigitalOceanOperations;
import org.apache.camel.component.digitalocean.constants.DigitalOceanResources;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DigitalOceanConfiguration {
    @UriPath(enums="create,update,delete,list,ownList,get,listBackups,listActions,listNeighbors,listSnapshots,listKernels,listAllNeighbors,enableBackups,disableBackups,reboot,powerCycle,shutdown,powerOn,powerOff,restore,resetPassword,resize,rebuild,rename,changeKernel,enableIpv6,enablePrivateNetworking,takeSnapshot,transfer,convert,attach,detach,assign,unassign,tag,untag")
    private DigitalOceanOperations operation;
    @UriParam(enums="account,actions,blockStorages,droplets,mages,snapshots,keys,regions,sizes,floatingIPs,tags")
    @Metadata(required=true)
    private DigitalOceanResources resource;
    @UriParam(label="advanced")
    private DigitalOceanClient digitalOceanClient;
    @UriParam(label="security", secret=true)
    private String oAuthToken;
    @UriParam(defaultValue="1")
    private Integer page = 1;
    @UriParam(defaultValue="25")
    private Integer perPage = 25;
    @UriParam(label="proxy")
    private String httpProxyHost;
    @UriParam(label="proxy", secret=true)
    private String httpProxyUser;
    @UriParam(label="proxy", secret=true)
    private String httpProxyPassword;
    @UriParam(label="proxy")
    private Integer httpProxyPort;

    public DigitalOceanResources getResource() {
        return this.resource;
    }

    public void setResource(DigitalOceanResources resource) {
        this.resource = resource;
    }

    public DigitalOceanOperations getOperation() {
        return this.operation;
    }

    public void setOperation(DigitalOceanOperations operation) {
        this.operation = operation;
    }

    public String getOAuthToken() {
        return this.oAuthToken;
    }

    public void setOAuthToken(String oAuthToken) {
        this.oAuthToken = oAuthToken;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public DigitalOceanClient getDigitalOceanClient() {
        return this.digitalOceanClient;
    }

    public void setDigitalOceanClient(DigitalOceanClient digitalOceanClient) {
        this.digitalOceanClient = digitalOceanClient;
    }
}

