/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="1.0.0", scheme="direct", title="Direct", syntax="direct:name", remote=false, category={Category.CORE, Category.MESSAGING})
public class DirectEndpoint
extends DefaultEndpoint {
    private final DirectComponent component;
    private final String key;
    @UriPath(description="Name of direct endpoint")
    @Metadata(required=true)
    private String name;
    @UriParam(label="advanced")
    private boolean synchronous;
    @UriParam(label="producer", defaultValue="true")
    private boolean block = true;
    @UriParam(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @UriParam(label="producer", defaultValue="true")
    private boolean failIfNoConsumers = true;

    public DirectEndpoint(String uri, DirectComponent component) {
        super(uri, component);
        this.component = component;
        this.key = StringHelper.before(uri, "?", uri);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DirectProducer(this, this.key);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DirectConsumer answer = new DirectConsumer(this, processor, this.key);
        this.configureConsumer(answer);
        return answer;
    }

    @Deprecated
    public DirectConsumer getConsumer() throws InterruptedException {
        return this.component.getConsumer(this.key, this.block, this.timeout);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailIfNoConsumers() {
        return this.failIfNoConsumers;
    }

    public void setFailIfNoConsumers(boolean failIfNoConsumers) {
        this.failIfNoConsumers = failIfNoConsumers;
    }
}

