/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.DefaultConsumer;

public class DirectConsumer
extends DefaultConsumer
implements ShutdownAware,
Suspendable {
    private final DirectComponent component;
    private final String key;

    public DirectConsumer(DirectEndpoint endpoint, Processor processor, String key) {
        super(endpoint, processor);
        this.component = (DirectComponent)endpoint.getComponent();
        this.key = key;
    }

    @Override
    public DirectEndpoint getEndpoint() {
        return (DirectEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.component.addConsumer(this.key, this);
    }

    @Override
    protected void doStop() throws Exception {
        this.component.removeConsumer(this.key, this);
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        this.component.removeConsumer(this.key, this);
    }

    @Override
    protected void doResume() throws Exception {
        this.component.addConsumer(this.key, this);
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        return 0;
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }
}

