/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;

public class DnsDigProducer
extends DefaultProducer {
    public DnsDigProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        int dclass;
        String dclassValue;
        String server = exchange.getIn().getHeader("dns.server", String.class);
        SimpleResolver resolver = new SimpleResolver(server);
        int type = Type.value(exchange.getIn().getHeader("dns.type", String.class));
        if (type == -1) {
            type = 1;
        }
        if ((dclassValue = exchange.getIn().getHeader("dns.class", String.class)) == null) {
            dclassValue = "";
        }
        if ((dclass = DClass.value(dclassValue)) == -1) {
            dclass = 1;
        }
        Name name = Name.fromString(exchange.getIn().getHeader("dns.name", String.class), Name.root);
        Record rec = Record.newRecord(name, type, dclass);
        Message query = Message.newQuery(rec);
        Message response = resolver.send(query);
        exchange.getIn().setBody(response);
    }
}

